// SPDX-License-Identifier: Unlicense

#ifndef FILE_H
#define FILE_H

#include "typedefs.h"

#include <map>
#include <string>
#include <vector>

namespace File
{
enum struct Type
{
  shred,
  psarc,
  png,
  dds,
  astc,
#ifdef SHR3D_ENVIRONMENT_SKYBOX
  astc6, // skybox on android
#endif // SHR3D_ENVIRONMENT_SKYBOX
  tsv,
#ifdef SHR3D_ENVIRONMENT_STAGE
  stage,
  stage_a,
#endif // SHR3D_ENVIRONMENT_STAGE
  unknown
};

bool exists(const char* filePath);
bool directoryExists(const char* filePath);
const char* filename(const char* filePath);
const char* extension(const char* filePath);
std::string replaceExtension(const char* filePath, const char* newExtension);
u64 modTime(const char* filePath);

void createDirectories(const char* filePath);
void copy(const char* srcFilepath, const char* destFilepath);
std::vector<std::string> filesInDirectory(const char* filePath);
std::string fixInvalidCharsInFilepath(const std::string& filePath);
std::string uniqueFilepathInDirectory(const std::string& directory, const std::string& extension);

// #ifndef PLATFORM_EMSCRIPTEN
FILE* fopen_u8(const char* filePath, const char* mode);
std::vector<u8> read(const char* filePath);
void write(const char* filePath, const void* content, size_t len);
// #endif // PLATFORM_EMSCRIPTEN

std::vector<std::string> openFileDialog(const wchar_t* filter, bool allowMultiSelect);
std::string openDirectoryDialog();

void shellExecute(const char* filePathOrUrl);
void createPathDirectories();

#ifdef PLATFORM_EMSCRIPTEN
Type type_cacheIpfsCid(const char* filePath, const u8* fileData4CC);
#endif // PLATFORM_EMSCRIPTEN
Type type(const char* filePath);
} // namespace File

#endif // FILE_H
