// SPDX-License-Identifier: Unlicense

#ifndef FONT_H
#define FONT_H

#include "type.h"

namespace Font1
{
  void init();

  extern GLuint fretNumberTextureCache[25];
  extern GLuint noteNamesTextureCache[12];

#ifdef SHR3D_FONT_BITMAP
  inline constexpr i32 charWidth = 6;
  inline constexpr i32 charHeight = 10;
  inline constexpr i32 missingCharWidth = 6;
  inline constexpr f32 fontScaleFactor = 3.2f;
#endif // SHR3D_FONT_BITMAP
#ifdef SHR3D_FONT_MSDF
  // the width needs to be calculated since we are not using a mono spaced font
  inline constexpr i32 charHeight = 32;
  inline constexpr f32 fontScaleFactor = 1.0f;
#endif // SHR3D_FONT_MSDF
  i32 textureWidth(const char* text);
  void draw(const char* text, f32 posX, f32 posY, f32 posZ, f32 scaleX, f32 scaleY);
  //void drawFretNumber(i32 fretNumber, f32 posX, f32 posY, f32 posZ, f32 scaleX, f32 scaleY);
  //void drawFretNumber2(GLint modelUniform, i32 fretNumber, f32 posX, f32 posY, f32 posZ, f32 scaleX, f32 scaleY);
  //void drawNoteNameFlat(MidiNote midiNote, f32 posX, f32 posY, f32 posZ, f32 scaleX, f32 scaleY);

  //mat4 createFontModelMatrix(f32 posX, f32 posY, f32 posZ, f32 scaleX, f32 scaleY);
  GLuint textTexture(const char* text);
}

#endif // FONT_H