// SPDX-License-Identifier: Unlicense

#ifndef HUD_H
#define HUD_H

#include "typedefs.h"

struct mat4;

namespace Hud
{
  // With Co-Op we could have more than one Hud.
  // Before Co-Op everything was global.
  struct Ctx
  {
    ArrangementIndex arrangementIndexLastFrame = -1;
    TimeNS arrangementSwitchTime;
  };

  void tick(Ctx& ctx, ArrangementIndex selectedArrangementIndex, i32 resolutionWidth, i32 resolutionHeight);
  void render(const Ctx& ctx, ArrangementIndex selectedArrangementIndex, i32 resolutionWidth, i32 resolutionHeight);
#ifdef SHR3D_OPENXR
  void render(const Ctx& ctx, ArrangementIndex selectedArrangementIndex, const mat4& viewProjectionMat);
#endif // SHR3D_OPENXR
}

#endif // HUD_H
