// SPDX-License-Identifier: Unlicense

#ifndef INI_H
#define INI_H

#include "typedefs.h"

#include <string>
#include <vector>
#include <map>

namespace Ini
{
  std::map<std::string, std::map<std::string, std::string>> loadIniContent(const char* str, u64 strSize);
  struct KeyValue
  {
    std::string key;
    std::string value;
  };
  std::map<std::string, std::vector<KeyValue>> loadIniContent_keepKeyOrder(const char* str, u64 strSize);

  void saveIniFile(const char* filePath, const std::map<std::string, std::map<std::string, std::string>>& iniContent);
  struct SectionKeyValue
  {
    std::string section;
    std::map<std::string, std::string> keyValues;
  };
  void saveIniFile_keepSectionOrder(const char* filePath, const std::vector<SectionKeyValue>& iniContent);
}

#endif // INI_H
