// SPDX-License-Identifier: Unlicense

#ifndef RECORDER_H
#define RECORDER_H

#include "typedefs.h"

#ifdef SHR3D_RECORDER

#include <string>

namespace Song { struct Info; };

namespace Recorder
{
  // http://soundfile.sapp.org/doc/WaveFormat/
  struct RIFFWAVE
  {
    const u8  ChunkID[4] = { 'R', 'I', 'F', 'F' };                     // RIFF Header Magic header
    u32       ChunkSize; /*overwrite*/                                 // RIFF Chunk Size filesize-8 or 36+Subchunk2Size
    const u8  Format[4] = { 'W', 'A', 'V', 'E' };                      // WAVE Header
    const u8  Subchunk1ID[4] = { 'f', 'm', 't', ' ' };                 // FMT header
    u32       Subchunk1Size = 16;                                      // Size of the fmt chunk
    const u16 AudioFormat = 3;                  // Audio format 1=PCM, 3=IEEE Float, 6=mulaw,7=alaw, 257=IBM Mu-Law, 258=IBM A-Law, 259=ADPCM
    const u16 NumChannels = 2;                                         // Number of channels 1=Mono 2=Sterio
    u32       SampleRate = 48000;                                      // Sampling Frequency in Hz
    u32       ByteRate = 48000 * 2 * 32 / 8; // bytes per second
    const u16 BlockAlign = 8;                   // 2=16-bit mono, 4=16-bit stereo , 6=24-bit stereo, 8=32-bit stereo
    const u16 BitsPerSample = 32;              // Number of bits per sample
    const u8  Subchunk2ID[4] = { 'd', 'a', 't', 'a' };                 // "data"  string
    u32       Subchunk2Size = 0; /*overwrite*/                         // Sampled data length
  };
  static_assert(sizeof(RIFFWAVE) == 44);

  void init();
  void processBlock(const f32* const inBlock[2], i32 blockSize, bool recordOnlyWhenMusicPlays = true);
  void saveWavFile(const char* wavFilepath, const i32 sampelRate);

  std::string generateWavPath(const Song::Info& songInfo);
}

#endif // SHR3D_RECORDER

#endif // RECORDER_H
