// SPDX-License-Identifier: Unlicense

#include "sfxCore.h"

#ifdef SHR3D_SFX_CORE

#include "file.h"
#include "global.h"
#include "string_.h"
#include "sfxCore/airWindows/sfxCoreAirWindows.h"

#include <string.h>

#ifdef SHR3D_SFX_CORE_NEURALAMPMODELER
std::vector<SfxCoreNeuralAmpModeler> SFXCore::nam;
#endif // SHR3D_SFX_CORE_NEURALAMPMODELER
#ifdef SHR3D_SFX_CORE_RAKARRACK
std::vector<Reverb> SFXCore::reverb;
std::vector<Echo> SFXCore::echo;
std::vector<Chorus> SFXCore::chorus;
std::vector<Phaser> SFXCore::phaser;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<Distorsion> SFXCore::distorsion;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<EQ> SFXCore::eq;
std::vector<Compressor> SFXCore::compressor;
std::vector<DynamicFilter> SFXCore::wahWah;
std::vector<Alienwah> SFXCore::alienWah;
std::vector<Pan> SFXCore::pan;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#if 0
std::vector<Harmonizer> SFXCore::harmonizer;
#endif
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<MusicalDelay> SFXCore::musicalDelay;
std::vector<NoiseGate> SFXCore::noiseGate;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<Derelict> SFXCore::derelict;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<AnalogPhaser> SFXCore::analogPhaser;
std::vector<Valve> SFXCore::valve;
std::vector<DualFlange> SFXCore::dualFlange;
std::vector<Ring> SFXCore::ring;
std::vector<Exciter> SFXCore::exciter;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<DistBand> SFXCore::distBand;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<Arpie> SFXCore::arpie;
std::vector<Expander> SFXCore::expander;
std::vector<Shuffle> SFXCore::shuffle;
std::vector<Synthfilter> SFXCore::synthFilter;
std::vector<VaryBand> SFXCore::varyBand;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#ifdef SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
std::vector<Convolotron> SFXCore::convolotron;
#endif // SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<MuTroMojo> SFXCore::muTroMojo;
std::vector<Echoverse> SFXCore::echoverse;
std::vector<CoilCrafter> SFXCore::coilCrafter;
std::vector<ShelfBoost> SFXCore::shelfBoost;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<Vocoder> SFXCore::vocoder;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<Sustainer> SFXCore::sustainer;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<Sequence> SFXCore::sequence;
std::vector<Shifter> SFXCore::shifter;
std::vector<StompBox> SFXCore::stompBox;
#ifdef SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
std::vector<Reverbtron> SFXCore::reverbtron;
#endif // SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<Echotron> SFXCore::echotron;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<StereoHarm> SFXCore::stereoHarm;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
std::vector<CompBand> SFXCore::compBand;
std::vector<OpticalTrem> SFXCore::opticalTrem;
std::vector<Vibe> SFXCore::vibe;
#endif // SHR3D_SFX_CORE_RAKARRACK

void SFXCore::init()
{
#ifdef SHR3D_SFX_CORE_NEURALAMPMODELER
  SfxCoreNeuralAmpModeler::init();
#endif // SHR3D_SFX_CORE_NEURALAMPMODELER
}

#ifdef SHR3D_SFX_CORE_RAKARRACK
static void Vol_Efx(SfxCoreRakarrack sfxCore, f32 volume, f32** inBlock, f32** outBlock, const i32 blockSize)
{
  f32 v1, v2;

  if (volume < 0.5f)
  {
    v1 = 1.0f;
    v2 = volume * 2.0f;
  }
  else
  {
    v1 = (1.0f - volume) * 2.0f;
    v2 = 1.0f;
  }

  if ((sfxCore == SfxCoreRakarrack::Reverb) || (sfxCore == SfxCoreRakarrack::MusicalDelay))
    v2 *= v2;

  for (i32 i = 0; i < blockSize; i++)
  {
    outBlock[0][i] = inBlock[0][i] * v2 + outBlock[0][i] * v1;
    outBlock[1][i] = inBlock[1][i] * v2 + outBlock[1][i] * v1;
  }
}
#endif // SHR3D_SFX_CORE_RAKARRACK

// return true if outBlock was written
ProcessBlockResult SFXCore::processBlock(const SfxId sfxId, i32 instance, f32** inBlock, f32** outBlock, i32 blockSize)
{
  switch (sfxId.system)
  {
#ifdef SHR3D_SFX_CORE
  case SfxSystem::core:
  {
    const SfxCore sfxCore = SfxCore(sfxId.sfxIndex);
    switch (sfxCore)
    {
#ifdef SHR3D_SFX_CORE_NEURALAMPMODELER
    case SfxCore::NeuralAmpModeler:
      nam[instance].processBlock(inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_NEURALAMPMODELER
#ifdef SHR3D_SFX_CORE_HEXFIN
#ifdef SHR3D_SFX_CORE_HEXFIN_DIVIDED
    case SfxCore::Hexfin:
      return ProcessBlockResult::ProcessedInInBlock;
#endif // SHR3D_SFX_CORE_HEXFIN_DIVIDED
#endif // SHR3D_SFX_CORE_HEXFIN
    default:
      unreachable();
    }
  }
#endif // SHR3D_SFX_CORE
#ifdef SHR3D_SFX_CORE_AIRWINDOWS
  case SfxSystem::coreAirWindows:
  {
    const SfxCoreAirWindows_ sfxCoreAirWindows = SfxCoreAirWindows_(sfxId.sfxIndex);
    SfxCoreAirWindows::processBlock(sfxCoreAirWindows, instance, inBlock, outBlock, blockSize);
    return ProcessBlockResult::ProcessedInOutBlock;
  }
#endif // SHR3D_SFX_CORE_AIRWINDOWS
#ifdef SHR3D_SFX_CORE_RAKARRACK
  case SfxSystem::coreRakarrack:
  {
    const SfxCoreRakarrack sfxCoreRakarrack = SfxCoreRakarrack(sfxId.sfxIndex);
    switch (sfxCoreRakarrack)
    {
    case SfxCoreRakarrack::Reverb:
      if (reverb.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      reverb[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, reverb[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Echo:
      if (echo.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      echo[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, echo[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Chorus:
    case SfxCoreRakarrack::Flanger:
      if (chorus.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      chorus[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, chorus[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Phaser:
      if (phaser.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      phaser[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, phaser[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Overdrive:
    case SfxCoreRakarrack::Distorsion:
      if (distorsion.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      distorsion[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, distorsion[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::EQ:
    case SfxCoreRakarrack::ParametricEQ:
    case SfxCoreRakarrack::Cabinet:
      if (eq.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      eq[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
    case SfxCoreRakarrack::Compressor:
      if (compressor.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      compressor[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
    case SfxCoreRakarrack::WahWah:
      if (wahWah.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      wahWah[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, wahWah[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::AlienWah:
      if (alienWah.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      alienWah[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, alienWah[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;

    case SfxCoreRakarrack::Pan:
      if (pan.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      memcpy(outBlock[0], inBlock[0], blockSize * sizeof(f32));
      memcpy(outBlock[1], inBlock[1], blockSize * sizeof(f32));
      pan[instance].processBlock(outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, pan[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#if 0
    case SfxCoreRakarrack::Harmonizer:
      if (harmonizer.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      harmonizer[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, harmonizer[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::MusicalDelay:
      if (musicalDelay.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      musicalDelay[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, musicalDelay[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::NoiseGate:
      if (noiseGate.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      noiseGate[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Derelict:
      if (derelict.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      derelict[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, derelict[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::AnalogPhaser:
      if (analogPhaser.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      analogPhaser[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, analogPhaser[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Valve:
      if (valve.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      valve[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, valve[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::DualFlange:
      if (dualFlange.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      dualFlange[instance].processBlock(inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Ring:
      if (ring.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      ring[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, ring[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Exciter:
      if (exciter.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      exciter[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::DistBand:
      if (distBand.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      distBand[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, distBand[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Arpie:
      if (arpie.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      arpie[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, arpie[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Expander:
      if (expander.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      expander[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
    case SfxCoreRakarrack::Shuffle:
      if (shuffle.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      shuffle[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, shuffle[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Synthfilter:
      if (synthFilter.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      synthFilter[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, synthFilter[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::VaryBand:
      if (varyBand.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      varyBand[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, varyBand[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#ifdef SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
    case SfxCoreRakarrack::Convolotron:
      if (convolotron.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      convolotron[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, convolotron[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::MuTroMojo:
      if (muTroMojo.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      muTroMojo[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, muTroMojo[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Echoverse:
      if (echoverse.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      echoverse[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, echoverse[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::CoilCrafter:
      if (coilCrafter.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      coilCrafter[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
    case SfxCoreRakarrack::ShelfBoost:
      if (shelfBoost.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      shelfBoost[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Vocoder:
      if (vocoder.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      vocoder[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, vocoder[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Sustainer:
      if (sustainer.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      sustainer[instance].processBlock(inBlock, blockSize);
      return ProcessBlockResult::ProcessedInInBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Sequence:
      if (sequence.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      sequence[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, sequence[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Shifter:
      if (shifter.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      shifter[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, shifter[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::StompBox:
      if (stompBox.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      stompBox[instance].processBlock(inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
    case SfxCoreRakarrack::Reverbtron:
      if (reverbtron.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      memcpy(outBlock[0], inBlock[0], blockSize * sizeof(f32));
      memcpy(outBlock[1], inBlock[1], blockSize * sizeof(f32));

      reverbtron[instance].processBlock(outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, reverbtron[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Echotron:
      if (echotron.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      echotron[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, echotron[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::StereoHarm:
      if (stereoHarm.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      stereoHarm[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, stereoHarm[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::CompBand:
      if (compBand.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      compBand[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, compBand[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::OpticalTrem:
      if (opticalTrem.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      opticalTrem[instance].processBlock(inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    case SfxCoreRakarrack::Vibe:
      if (vibe.size() <= instance)
        return ProcessBlockResult::ProcessedInInBlock;

      vibe[instance].processBlock(inBlock, outBlock, blockSize);
      Vol_Efx(sfxCoreRakarrack, vibe[instance].outvolume, inBlock, outBlock, blockSize);
      return ProcessBlockResult::ProcessedInOutBlock;
    default:
      unreachable();
    }
  }
#endif // SHR3D_SFX_CORE_RAKARRACK
#ifdef SHR3D_SFX_CORE_EXTENSION_V2
  case SfxSystem::coreExtensionV2:
    break;
#endif // SHR3D_SFX_CORE_EXTENSION_V2
  default:
    unreachable();
  }
  unreachable();
}

std::string SFXCore::saveParameters(const SfxId sfxId, i32 instance)
{
  //const SfxCore sfxCore = SfxCore(index);

  //ASSERT(sfxCore > SfxCore::EMPTY);
  //ASSERT(sfxCore < SfxCore::COUNT);

  std::string params;

  switch (sfxId.system)
  {
  case SfxSystem::core:
  {
    const SfxCore sfxCore = SfxCore(sfxId.sfxIndex);
    switch (sfxCore)
    {
#ifdef SHR3D_SFX_CORE_NEURALAMPMODELER
    case SfxCore::NeuralAmpModeler:
      if (SFXCore::nam.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::nam.resize(instance + 1);
      }
      params =
        to_string(SFXCore::nam[instance].getpar(0)) + ',' +
        to_string(SFXCore::nam[instance].getpar(1)) + ',' +
        to_string(SFXCore::nam[instance].getpar(2)) + ',' +
        to_string(SFXCore::nam[instance].getpar(3)) + ',' +
        to_string(SFXCore::nam[instance].getpar(4)) + ',' +
        to_string(SFXCore::nam[instance].getpar(5)) + ',' +
        to_string(SFXCore::nam[instance].getpar(6)) + ',' +
        to_string(SFXCore::nam[instance].getpar(7)) + ',' +
        to_string(SFXCore::nam[instance].getpar(8)) + ',' +
        to_string(SFXCore::nam[instance].getpar(9)) + ',' +
        to_string(SFXCore::nam[instance].getpar(10)) + ',' +
        (SFXCore::nam[instance].loadedNamFileIndex >= 0 ? File::filename(Global::NeuralAmpModeler_NamFiles[SFXCore::nam[instance].loadedNamFileIndex].c_str()) + std::string(",") : ",") +
        (SFXCore::nam[instance].loadedIrFileIndex >= 0 ? File::filename(Global::NeuralAmpModeler_IrFiles[SFXCore::nam[instance].loadedIrFileIndex].c_str()) : "");
      return params;
#endif // SHR3D_SFX_CORE_NEURALAMPMODELER
#ifdef SHR3D_SFX_CORE_HEXFIN
    case SfxCore::Hexfin:
      return {};
#endif // SHR3D_SFX_CORE_HEXFIN
    default:
      unreachable();
    }
  }
  break;
#ifdef SHR3D_SFX_CORE_AIRWINDOWS
  case SfxSystem::coreAirWindows:
  {
    const SfxCoreAirWindows_ sfxCoreAirWindows = SfxCoreAirWindows_(sfxId.sfxIndex);
    return SfxCoreAirWindows::saveParameters(sfxCoreAirWindows, instance);
  }
  break;
#endif // SHR3D_SFX_CORE_AIRWINDOWS
#ifdef SHR3D_SFX_CORE_RAKARRACK
  case SfxSystem::coreRakarrack:
  {
    const SfxCoreRakarrack sfxCoreRakarrack = SfxCoreRakarrack(sfxId.sfxIndex);
    switch (sfxCoreRakarrack)
    {
    case SfxCoreRakarrack::Reverb:
      if (SFXCore::reverb.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::reverb.resize(instance + 1);
      }
      params =
        to_string(SFXCore::reverb[instance].getpar(0)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(1)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(2)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(3)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(4)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(5)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(6)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(7)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(8)) + ',' +
        to_string(SFXCore::reverb[instance].getpar(9));
      return params;
    case SfxCoreRakarrack::Echo:
      if (SFXCore::echo.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::echo.resize(instance + 1);
      }
      params =
        to_string(SFXCore::echo[instance].getpar(0)) + ',' +
        to_string(SFXCore::echo[instance].getpar(1)) + ',' +
        to_string(SFXCore::echo[instance].getpar(2)) + ',' +
        to_string(SFXCore::echo[instance].getpar(3)) + ',' +
        to_string(SFXCore::echo[instance].getpar(4)) + ',' +
        to_string(SFXCore::echo[instance].getpar(5)) + ',' +
        to_string(SFXCore::echo[instance].getpar(6)) + ',' +
        to_string(SFXCore::echo[instance].getpar(7)) + ',' +
        to_string(SFXCore::echo[instance].getpar(8));
      return params;
    case SfxCoreRakarrack::Chorus:
    case SfxCoreRakarrack::Flanger:
      if (SFXCore::chorus.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::chorus.resize(instance + 1);
      }
      params =
        to_string(SFXCore::chorus[instance].getpar(0)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(1)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(2)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(3)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(4)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(5)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(6)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(7)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(8)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(9)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(10)) + ',' +
        to_string(SFXCore::chorus[instance].getpar(11));
      return params;
    case SfxCoreRakarrack::Phaser:
      if (SFXCore::phaser.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::phaser.resize(instance + 1);
      }
      params =
        to_string(SFXCore::phaser[instance].getpar(0)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(1)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(2)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(3)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(4)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(5)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(6)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(7)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(8)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(9)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(10)) + ',' +
        to_string(SFXCore::phaser[instance].getpar(11));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Overdrive:
    case SfxCoreRakarrack::Distorsion:
      if (SFXCore::distorsion.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::distorsion.resize(instance + 1);
      }
      params =
        to_string(SFXCore::distorsion[instance].getpar(0)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(1)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(2)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(3)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(4)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(5)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(6)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(7)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(8)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(9)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(10)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(11)) + ',' +
        to_string(SFXCore::distorsion[instance].getpar(12));
      return params;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::EQ:
      if (SFXCore::eq.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::eq.resize(instance + 1);
      }
      params =
        to_string(SFXCore::eq[instance].getpar(12)) + ',' +
        to_string(SFXCore::eq[instance].getpar(17)) + ',' +
        to_string(SFXCore::eq[instance].getpar(22)) + ',' +
        to_string(SFXCore::eq[instance].getpar(27)) + ',' +
        to_string(SFXCore::eq[instance].getpar(32)) + ',' +
        to_string(SFXCore::eq[instance].getpar(37)) + ',' +
        to_string(SFXCore::eq[instance].getpar(42)) + ',' +
        to_string(SFXCore::eq[instance].getpar(47)) + ',' +
        to_string(SFXCore::eq[instance].getpar(52)) + ',' +
        to_string(SFXCore::eq[instance].getpar(57)) + ',' +
        to_string(SFXCore::eq[instance].getpar(0)) + ',' +
        to_string(SFXCore::eq[instance].getpar(13));
      return params;
    case SfxCoreRakarrack::ParametricEQ:
      if (SFXCore::eq.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::eq.resize(instance + 1);
      }
      params = to_string(SFXCore::eq[instance].getpar(11)) + ',' +
        to_string(SFXCore::eq[instance].getpar(12)) + ',' +
        to_string(SFXCore::eq[instance].getpar(13)) + ',' +
        to_string(SFXCore::eq[instance].getpar(16)) + ',' +
        to_string(SFXCore::eq[instance].getpar(17)) + ',' +
        to_string(SFXCore::eq[instance].getpar(18)) + ',' +
        to_string(SFXCore::eq[instance].getpar(21)) + ',' +
        to_string(SFXCore::eq[instance].getpar(22)) + ',' +
        to_string(SFXCore::eq[instance].getpar(23)) + ',' +
        to_string(SFXCore::eq[instance].getpar(0));
      return params;
    case SfxCoreRakarrack::Cabinet:
      if (SFXCore::eq.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::eq.resize(instance + 1);
      }
      params =
        to_string(SFXCore::eq[instance].cabinet_preset) + ',' +
        to_string(SFXCore::eq[instance].getpar(0));
      return params;
    case SfxCoreRakarrack::Compressor:
      if (SFXCore::compressor.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::compressor.resize(instance + 1);
      }
      params =
        to_string(SFXCore::compressor[instance].getpar(0)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(1)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(2)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(3)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(4)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(5)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(6)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(7)) + ',' +
        to_string(SFXCore::compressor[instance].getpar(8));
      return params;
    case SfxCoreRakarrack::WahWah:
      if (SFXCore::wahWah.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::wahWah.resize(instance + 1);
      }
      params =
        to_string(SFXCore::wahWah[instance].getpar(0)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(1)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(2)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(3)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(4)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(5)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(6)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(7)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(8)) + ',' +
        to_string(SFXCore::wahWah[instance].getpar(9));
      return params;
    case SfxCoreRakarrack::AlienWah:
      if (SFXCore::alienWah.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::alienWah.resize(instance + 1);
      }
      params =
        to_string(SFXCore::alienWah[instance].getpar(0)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(1)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(2)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(3)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(4)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(5)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(6)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(7)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(8)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(9)) + ',' +
        to_string(SFXCore::alienWah[instance].getpar(10));
      return params;
    case SfxCoreRakarrack::Pan:
      if (SFXCore::pan.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::pan.resize(instance + 1);
      }
      params =
        to_string(SFXCore::pan[instance].getpar(0)) + ',' +
        to_string(SFXCore::pan[instance].getpar(1)) + ',' +
        to_string(SFXCore::pan[instance].getpar(2)) + ',' +
        to_string(SFXCore::pan[instance].getpar(3)) + ',' +
        to_string(SFXCore::pan[instance].getpar(4)) + ',' +
        to_string(SFXCore::pan[instance].getpar(5)) + ',' +
        to_string(SFXCore::pan[instance].getpar(6)) + ',' +
        to_string(SFXCore::pan[instance].getpar(7)) + ',' +
        to_string(SFXCore::pan[instance].getpar(8));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#if 0
    case SfxCore::Harmonizer:
      if (SFXCore::harmonizer.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::harmonizer.resize(instance + 1);
      }
      params =
        to_string(SFXCore::harmonizer[instance].getpar(0)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(1)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(2)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(3)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(4)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(5)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(6)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(7)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(8)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(9)) + ',' +
        to_string(SFXCore::harmonizer[instance].getpar(10));
      return params;
#endif
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::MusicalDelay:
      if (SFXCore::musicalDelay.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::musicalDelay.resize(instance + 1);
      }
      params =
        to_string(SFXCore::musicalDelay[instance].getpar(0)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(1)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(2)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(3)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(4)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(5)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(6)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(7)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(8)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(9)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(10)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(11)) + ',' +
        to_string(SFXCore::musicalDelay[instance].getpar(12));
      return params;
    case SfxCoreRakarrack::NoiseGate:
      if (SFXCore::noiseGate.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::noiseGate.resize(instance + 1);
      }
      params =
        //to_string(SFXCore::noiseGate[instance].getpar(0)) + ',' +
        to_string(SFXCore::noiseGate[instance].getpar(1)) + ',' +
        to_string(SFXCore::noiseGate[instance].getpar(2)) + ',' +
        to_string(SFXCore::noiseGate[instance].getpar(3)) + ',' +
        to_string(SFXCore::noiseGate[instance].getpar(4)) + ',' +
        to_string(SFXCore::noiseGate[instance].getpar(5)) + ',' +
        to_string(SFXCore::noiseGate[instance].getpar(6)) + ',' +
        to_string(SFXCore::noiseGate[instance].getpar(7));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Derelict:
      if (SFXCore::derelict.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::derelict.resize(instance + 1);
      }
      params =
        to_string(SFXCore::derelict[instance].getpar(0)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(1)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(2)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(3)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(4)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(5)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(6)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(7)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(8)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(9)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(10)) + ',' +
        to_string(SFXCore::derelict[instance].getpar(11));
      return params;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::AnalogPhaser:
      if (SFXCore::analogPhaser.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::analogPhaser.resize(instance + 1);
      }
      params =
        to_string(SFXCore::analogPhaser[instance].getpar(0)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(1)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(2)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(3)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(4)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(5)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(6)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(7)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(8)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(9)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(10)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(11)) + ',' +
        to_string(SFXCore::analogPhaser[instance].getpar(12));
      return params;
    case SfxCoreRakarrack::Valve:
      if (SFXCore::valve.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::valve.resize(instance + 1);
      }
      params =
        to_string(SFXCore::valve[instance].getpar(0)) + ',' +
        to_string(SFXCore::valve[instance].getpar(1)) + ',' +
        to_string(SFXCore::valve[instance].getpar(2)) + ',' +
        to_string(SFXCore::valve[instance].getpar(3)) + ',' +
        to_string(SFXCore::valve[instance].getpar(4)) + ',' +
        to_string(SFXCore::valve[instance].getpar(5)) + ',' +
        to_string(SFXCore::valve[instance].getpar(6)) + ',' +
        to_string(SFXCore::valve[instance].getpar(7)) + ',' +
        to_string(SFXCore::valve[instance].getpar(8)) + ',' +
        to_string(SFXCore::valve[instance].getpar(9)) + ',' +
        to_string(SFXCore::valve[instance].getpar(10)) + ',' +
        to_string(SFXCore::valve[instance].getpar(11)) + ',' +
        to_string(SFXCore::valve[instance].getpar(12));
      return params;
    case SfxCoreRakarrack::DualFlange:
      if (SFXCore::dualFlange.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::dualFlange.resize(instance + 1);
      }
      params =
        to_string(SFXCore::dualFlange[instance].getpar(0)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(1)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(2)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(3)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(4)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(5)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(6)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(7)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(8)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(9)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(10)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(11)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(12)) + ',' +
        to_string(SFXCore::dualFlange[instance].getpar(13));
      return params;
    case SfxCoreRakarrack::Ring:
      if (SFXCore::ring.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::ring.resize(instance + 1);
      }
      params =
        to_string(SFXCore::ring[instance].getpar(0)) + ',' +
        to_string(SFXCore::ring[instance].getpar(1)) + ',' +
        to_string(SFXCore::ring[instance].getpar(2)) + ',' +
        to_string(SFXCore::ring[instance].getpar(3)) + ',' +
        to_string(SFXCore::ring[instance].getpar(4)) + ',' +
        to_string(SFXCore::ring[instance].getpar(5)) + ',' +
        to_string(SFXCore::ring[instance].getpar(6)) + ',' +
        to_string(SFXCore::ring[instance].getpar(7)) + ',' +
        to_string(SFXCore::ring[instance].getpar(8)) + ',' +
        to_string(SFXCore::ring[instance].getpar(9)) + ',' +
        to_string(SFXCore::ring[instance].getpar(10)) + ',' +
        to_string(SFXCore::ring[instance].getpar(11)) + ',' +
        to_string(SFXCore::ring[instance].getpar(12));
      return params;
    case SfxCoreRakarrack::Exciter:
      if (SFXCore::exciter.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::exciter.resize(instance + 1);
      }
      params =
        to_string(SFXCore::exciter[instance].getpar(0)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(1)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(2)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(3)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(4)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(5)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(6)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(7)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(8)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(9)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(10)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(11)) + ',' +
        to_string(SFXCore::exciter[instance].getpar(12));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::DistBand:
      if (SFXCore::distBand.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::distBand.resize(instance + 1);
      }
      params =
        to_string(SFXCore::distBand[instance].getpar(0)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(1)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(2)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(3)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(4)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(5)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(6)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(7)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(8)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(9)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(10)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(11)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(12)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(13)) + ',' +
        to_string(SFXCore::distBand[instance].getpar(14));
      return params;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Arpie:
      if (SFXCore::arpie.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::arpie.resize(instance + 1);
      }
      params =
        to_string(SFXCore::arpie[instance].getpar(0)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(1)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(2)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(3)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(4)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(5)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(6)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(7)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(8)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(9)) + ',' +
        to_string(SFXCore::arpie[instance].getpar(10));
      return params;
    case SfxCoreRakarrack::Expander:
      if (SFXCore::expander.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::expander.resize(instance + 1);
      }
      params =
        to_string(SFXCore::expander[instance].getpar(0)) + ',' +
        to_string(SFXCore::expander[instance].getpar(1)) + ',' +
        to_string(SFXCore::expander[instance].getpar(2)) + ',' +
        to_string(SFXCore::expander[instance].getpar(3)) + ',' +
        to_string(SFXCore::expander[instance].getpar(4)) + ',' +
        to_string(SFXCore::expander[instance].getpar(5)) + ',' +
        to_string(SFXCore::expander[instance].getpar(6));
      return params;
    case SfxCoreRakarrack::Shuffle:
      if (SFXCore::shuffle.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::shuffle.resize(instance + 1);
      }
      params =
        to_string(SFXCore::shuffle[instance].getpar(0)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(1)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(2)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(3)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(4)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(5)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(6)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(7)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(8)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(9)) + ',' +
        to_string(SFXCore::shuffle[instance].getpar(10));
      return params;
    case SfxCoreRakarrack::Synthfilter:
      if (SFXCore::synthFilter.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::synthFilter.resize(instance + 1);
      }
      params =
        to_string(SFXCore::synthFilter[instance].getpar(0)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(1)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(2)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(3)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(4)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(5)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(6)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(7)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(8)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(9)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(10)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(11)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(12)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(13)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(14)) + ',' +
        to_string(SFXCore::synthFilter[instance].getpar(15));
      return params;
    case SfxCoreRakarrack::VaryBand:
      if (SFXCore::varyBand.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::varyBand.resize(instance + 1);
      }
      params =
        to_string(SFXCore::varyBand[instance].getpar(0)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(1)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(2)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(3)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(4)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(5)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(6)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(7)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(8)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(9)) + ',' +
        to_string(SFXCore::varyBand[instance].getpar(10));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#ifdef SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
    case SfxCoreRakarrack::Convolotron:
      if (SFXCore::convolotron.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::convolotron.resize(instance + 1);
      }
      params =
        to_string(SFXCore::convolotron[instance].getpar(0)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(1)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(2)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(3)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(4)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(5)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(6)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(7)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(8)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(9)) + ',' +
        to_string(SFXCore::convolotron[instance].getpar(10));
      return params;
#endif // SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::MuTroMojo:
      if (SFXCore::muTroMojo.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::muTroMojo.resize(instance + 1);
      }
      params =
        to_string(SFXCore::muTroMojo[instance].getpar(0)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(1)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(2)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(3)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(4)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(5)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(6)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(7)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(8)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(9)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(10)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(11)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(12)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(13)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(14)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(15)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(16)) + ',' +
        to_string(SFXCore::muTroMojo[instance].getpar(17));
      return params;
    case SfxCoreRakarrack::Echoverse:
      if (SFXCore::echoverse.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::echoverse.resize(instance + 1);
      }
      params =
        to_string(SFXCore::echoverse[instance].getpar(0)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(1)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(2)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(3)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(4)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(5)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(6)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(7)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(8)) + ',' +
        to_string(SFXCore::echoverse[instance].getpar(9));
      return params;
    case SfxCoreRakarrack::CoilCrafter:
      if (SFXCore::coilCrafter.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::coilCrafter.resize(instance + 1);
      }
      params =
        to_string(SFXCore::coilCrafter[instance].getpar(0)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(1)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(2)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(3)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(4)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(5)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(6)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(7)) + ',' +
        to_string(SFXCore::coilCrafter[instance].getpar(8));
      return params;
    case SfxCoreRakarrack::ShelfBoost:
      if (SFXCore::shelfBoost.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::shelfBoost.resize(instance + 1);
      }
      params =
        to_string(SFXCore::shelfBoost[instance].getpar(0)) + ',' +
        to_string(SFXCore::shelfBoost[instance].getpar(1)) + ',' +
        to_string(SFXCore::shelfBoost[instance].getpar(2)) + ',' +
        to_string(SFXCore::shelfBoost[instance].getpar(3)) + ',' +
        to_string(SFXCore::shelfBoost[instance].getpar(4));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Vocoder:
      if (SFXCore::vocoder.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::vocoder.resize(instance + 1);
      }
      params =
        to_string(SFXCore::vocoder[instance].getpar(0)) + ',' +
        to_string(SFXCore::vocoder[instance].getpar(1)) + ',' +
        to_string(SFXCore::vocoder[instance].getpar(2)) + ',' +
        to_string(SFXCore::vocoder[instance].getpar(3)) + ',' +
        to_string(SFXCore::vocoder[instance].getpar(4)) + ',' +
        to_string(SFXCore::vocoder[instance].getpar(5)) + ',' +
        to_string(SFXCore::vocoder[instance].getpar(6));
      return params;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Sustainer:
      if (SFXCore::sustainer.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::sustainer.resize(instance + 1);
      }
      params =
        to_string(SFXCore::sustainer[instance].getpar(0)) + ',' +
        to_string(SFXCore::sustainer[instance].getpar(1));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Sequence:
      if (SFXCore::sequence.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::sequence.resize(instance + 1);
      }
      params =
        to_string(SFXCore::sequence[instance].getpar(0)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(1)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(2)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(3)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(4)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(5)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(6)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(7)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(8)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(9)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(10)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(11)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(12)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(13)) + ',' +
        to_string(SFXCore::sequence[instance].getpar(14));
      return params;
    case SfxCoreRakarrack::Shifter:
      if (SFXCore::shifter.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::shifter.resize(instance + 1);
      }
      params =
        to_string(SFXCore::shifter[instance].getpar(0)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(1)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(2)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(3)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(4)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(5)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(6)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(7)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(8)) + ',' +
        to_string(SFXCore::shifter[instance].getpar(9));
      return params;
    case SfxCoreRakarrack::StompBox:
      if (SFXCore::stompBox.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::stompBox.resize(instance + 1);
      }
      params =
        to_string(SFXCore::stompBox[instance].getpar(0)) + ',' +
        to_string(SFXCore::stompBox[instance].getpar(1)) + ',' +
        to_string(SFXCore::stompBox[instance].getpar(2)) + ',' +
        to_string(SFXCore::stompBox[instance].getpar(3)) + ',' +
        to_string(SFXCore::stompBox[instance].getpar(4)) + ',' +
        to_string(SFXCore::stompBox[instance].getpar(5));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
    case SfxCoreRakarrack::Reverbtron:
      if (SFXCore::reverbtron.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::reverbtron.resize(instance + 1);
      }
      params =
        to_string(SFXCore::reverbtron[instance].getpar(0)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(1)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(2)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(3)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(4)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(5)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(6)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(7)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(8)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(9)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(10)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(11)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(12)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(13)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(14)) + ',' +
        to_string(SFXCore::reverbtron[instance].getpar(15));
      return params;
#endif // SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Echotron:
      if (SFXCore::echotron.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::echotron.resize(instance + 1);
      }
      params =
        to_string(SFXCore::echotron[instance].getpar(0)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(1)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(2)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(3)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(4)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(5)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(6)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(7)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(8)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(9)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(10)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(11)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(12)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(13)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(14)) + ',' +
        to_string(SFXCore::echotron[instance].getpar(15));
      return params;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::StereoHarm:
      if (SFXCore::stereoHarm.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::stereoHarm.resize(instance + 1);
      }
      params =
        to_string(SFXCore::stereoHarm[instance].getpar(0)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(1)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(2)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(3)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(4)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(5)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(6)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(7)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(8)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(9)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(10)) + ',' +
        to_string(SFXCore::stereoHarm[instance].getpar(11));
      return params;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::CompBand:
      if (SFXCore::compBand.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::compBand.resize(instance + 1);
      }
      params =
        to_string(SFXCore::compBand[instance].getpar(0)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(1)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(2)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(3)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(4)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(5)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(6)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(7)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(8)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(9)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(10)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(11)) + ',' +
        to_string(SFXCore::compBand[instance].getpar(12));
      return params;
    case SfxCoreRakarrack::OpticalTrem:
      if (SFXCore::opticalTrem.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::opticalTrem.resize(instance + 1);
      }
      params =
        to_string(SFXCore::opticalTrem[instance].getpar(0)) + ',' +
        to_string(SFXCore::opticalTrem[instance].getpar(1)) + ',' +
        to_string(SFXCore::opticalTrem[instance].getpar(2)) + ',' +
        to_string(SFXCore::opticalTrem[instance].getpar(3)) + ',' +
        to_string(SFXCore::opticalTrem[instance].getpar(4)) + ',' +
        to_string(SFXCore::opticalTrem[instance].getpar(5));
      return params;
    case SfxCoreRakarrack::Vibe:
      if (SFXCore::vibe.size() <= instance)
      {
        ASSERT(false);
        //SFXCore::vibe.resize(instance + 1);
      }
      params =
        to_string(SFXCore::vibe[instance].getpar(0)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(1)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(2)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(3)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(4)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(5)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(6)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(7)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(8)) + ',' +
        to_string(SFXCore::vibe[instance].getpar(9));
      return params;
    }
  }
  break;
#endif // SHR3D_SFX_CORE_RAKARRACK
#ifdef SHR3D_SFX_CORE_EXTENSION_V2
  case SfxSystem::coreExtensionV2:
    break;
#endif // SHR3D_SFX_CORE_EXTENSION_V2
  default:
    unreachable();
  }
  unreachable();
}

void SFXCore::loadParameters(const SfxId sfxId, i32 instance, const std::string& parameters)
{
  //const SfxCore sfxCore = SfxCore(index);

  //ASSERT(sfxCore > SfxCore::EMPTY);
  //ASSERT(sfxCore < SfxCore::COUNT);

  const std::vector<std::string> params = String::split(parameters, ',');

  switch (sfxId.system)
  {
  case SfxSystem::core:
  {
    const SfxCore sfxCore = SfxCore(sfxId.sfxIndex);
    switch (sfxCore)
    {
#ifdef SHR3D_SFX_CORE_NEURALAMPMODELER
    case SfxCore::NeuralAmpModeler:
      if (SFXCore::nam.size() <= instance)
        SFXCore::nam.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::nam[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::nam[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::nam[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::nam[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::nam[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::nam[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::nam[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::nam[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::nam[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::nam[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::nam[instance].changepar(10, atoi2(params[10].c_str()));
        if (!params[11].empty())
        {
          for (u64 i = 0; i < Global::NeuralAmpModeler_NamFiles.size(); ++i)
          {
            if (Global::NeuralAmpModeler_NamFiles[i].ends_with(params[11]))
            {
              SFXCore::nam[instance].nextNamFileIndex = i32(i);
              break;
            }
          }
        }
        if (!params[12].empty())
        {
          for (u64 i = 0; i < Global::NeuralAmpModeler_IrFiles.size(); ++i)
          {
            if (Global::NeuralAmpModeler_IrFiles[i].ends_with(params[12]))
            {
              SFXCore::nam[instance].nextIrFileIndex = i32(i);
              break;
            }
          }
        }
      }
#endif // SHR3D_SFX_CORE_NEURALAMPMODELER
      return;
    default:
      unreachable();
    }
  }
#ifdef SHR3D_SFX_CORE_RAKARRACK
  case SfxSystem::coreRakarrack:
  {
    const SfxCoreRakarrack sfxCoreRakarrack = SfxCoreRakarrack(sfxId.sfxIndex);
    switch (sfxCoreRakarrack)
    {
    case SfxCoreRakarrack::Reverb:
      if (SFXCore::reverb.size() <= instance)
        SFXCore::reverb.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 10);
        SFXCore::reverb[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::reverb[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::reverb[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::reverb[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::reverb[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::reverb[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::reverb[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::reverb[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::reverb[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::reverb[instance].changepar(9, atoi2(params[9].c_str()));
      }
      return;
    case SfxCoreRakarrack::Echo:
      if (SFXCore::echo.size() <= instance)
        SFXCore::echo.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 9);
        SFXCore::echo[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::echo[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::echo[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::echo[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::echo[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::echo[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::echo[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::echo[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::echo[instance].changepar(8, atoi2(params[8].c_str()));
      }
      return;
    case SfxCoreRakarrack::Chorus:
    case SfxCoreRakarrack::Flanger:
      if (SFXCore::chorus.size() <= instance)
        SFXCore::chorus.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 12);
        SFXCore::chorus[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::chorus[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::chorus[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::chorus[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::chorus[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::chorus[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::chorus[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::chorus[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::chorus[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::chorus[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::chorus[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::chorus[instance].changepar(11, atoi2(params[11].c_str()));
      }
      else if (sfxCoreRakarrack == SfxCoreRakarrack::Flanger)
      {
        SFXCore::chorus[instance].setpreset(5);
      }
      return;
    case SfxCoreRakarrack::Phaser:
      if (SFXCore::phaser.size() <= instance)
        SFXCore::phaser.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 12);
        SFXCore::phaser[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::phaser[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::phaser[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::phaser[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::phaser[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::phaser[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::phaser[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::phaser[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::phaser[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::phaser[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::phaser[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::phaser[instance].changepar(11, atoi2(params[11].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Overdrive:
    case SfxCoreRakarrack::Distorsion:
      if (SFXCore::distorsion.size() <= instance)
        SFXCore::distorsion.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::distorsion[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::distorsion[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::distorsion[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::distorsion[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::distorsion[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::distorsion[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::distorsion[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::distorsion[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::distorsion[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::distorsion[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::distorsion[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::distorsion[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::distorsion[instance].changepar(12, atoi2(params[12].c_str()));
      }
      return;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::EQ:
      if (SFXCore::eq.size() <= instance)
        SFXCore::eq.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 12);
        SFXCore::eq[instance].changepar(12, atoi2(params[0].c_str()));
        SFXCore::eq[instance].changepar(17, atoi2(params[1].c_str()));
        SFXCore::eq[instance].changepar(22, atoi2(params[2].c_str()));
        SFXCore::eq[instance].changepar(27, atoi2(params[3].c_str()));
        SFXCore::eq[instance].changepar(32, atoi2(params[4].c_str()));
        SFXCore::eq[instance].changepar(37, atoi2(params[5].c_str()));
        SFXCore::eq[instance].changepar(42, atoi2(params[6].c_str()));
        SFXCore::eq[instance].changepar(47, atoi2(params[7].c_str()));
        SFXCore::eq[instance].changepar(52, atoi2(params[8].c_str()));
        SFXCore::eq[instance].changepar(57, atoi2(params[9].c_str()));
        SFXCore::eq[instance].changepar(0, atoi2(params[10].c_str()));
        SFXCore::eq[instance].changepar(13, atoi2(params[11].c_str()));
      }
      return;
    case SfxCoreRakarrack::ParametricEQ:
      if (SFXCore::eq.size() <= instance)
        SFXCore::eq.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 10);
        SFXCore::eq[instance].changepar(11, atoi2(params[0].c_str()));
        SFXCore::eq[instance].changepar(12, atoi2(params[1].c_str()));
        SFXCore::eq[instance].changepar(13, atoi2(params[2].c_str()));
        SFXCore::eq[instance].changepar(16, atoi2(params[3].c_str()));
        SFXCore::eq[instance].changepar(17, atoi2(params[4].c_str()));
        SFXCore::eq[instance].changepar(18, atoi2(params[5].c_str()));
        SFXCore::eq[instance].changepar(21, atoi2(params[6].c_str()));
        SFXCore::eq[instance].changepar(22, atoi2(params[7].c_str()));
        SFXCore::eq[instance].changepar(23, atoi2(params[8].c_str()));
        SFXCore::eq[instance].changepar(0, atoi2(params[9].c_str()));
      }
      return;
    case SfxCoreRakarrack::Cabinet:
      if (SFXCore::eq.size() <= instance)
        SFXCore::eq.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 2);
        SFXCore::eq[instance].setpreset_Cabinet(atoi2(params[0].c_str()));
        SFXCore::eq[instance].changepar(0, atoi2(params[1].c_str()));
      }
      return;
    case SfxCoreRakarrack::Compressor:
      if (SFXCore::compressor.size() <= instance)
        SFXCore::compressor.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 9);
        SFXCore::compressor[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::compressor[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::compressor[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::compressor[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::compressor[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::compressor[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::compressor[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::compressor[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::compressor[instance].changepar(8, atoi2(params[8].c_str()));
      }
      return;
    case SfxCoreRakarrack::WahWah:
      if (SFXCore::wahWah.size() <= instance)
        SFXCore::wahWah.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 10);
        SFXCore::wahWah[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::wahWah[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::wahWah[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::wahWah[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::wahWah[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::wahWah[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::wahWah[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::wahWah[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::wahWah[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::wahWah[instance].changepar(9, atoi2(params[9].c_str()));
      }
      return;
    case SfxCoreRakarrack::AlienWah:
      if (SFXCore::alienWah.size() <= instance)
        SFXCore::alienWah.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 11);
        SFXCore::alienWah[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::alienWah[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::alienWah[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::alienWah[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::alienWah[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::alienWah[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::alienWah[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::alienWah[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::alienWah[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::alienWah[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::alienWah[instance].changepar(10, atoi2(params[10].c_str()));
      }
      return;
    case SfxCoreRakarrack::Pan:
      if (SFXCore::pan.size() <= instance)
        SFXCore::pan.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 9);
        SFXCore::pan[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::pan[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::pan[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::pan[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::pan[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::pan[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::pan[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::pan[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::pan[instance].changepar(8, atoi2(params[8].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#if 0
    case SfxCore::Harmonizer:
      if (SFXCore::harmonizer.size() <= instance)
        SFXCore::harmonizer.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 11);
        SFXCore::harmonizer[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::harmonizer[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::harmonizer[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::harmonizer[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::harmonizer[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::harmonizer[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::harmonizer[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::harmonizer[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::harmonizer[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::harmonizer[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::harmonizer[instance].changepar(10, atoi2(params[10].c_str()));
      }
      return;
#endif
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::MusicalDelay:
      if (SFXCore::musicalDelay.size() <= instance)
        SFXCore::musicalDelay.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::musicalDelay[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::musicalDelay[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::musicalDelay[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::musicalDelay[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::musicalDelay[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::musicalDelay[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::musicalDelay[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::musicalDelay[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::musicalDelay[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::musicalDelay[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::musicalDelay[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::musicalDelay[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::musicalDelay[instance].changepar(12, atoi2(params[12].c_str()));
      }
      return;
    case SfxCoreRakarrack::NoiseGate:
      if (SFXCore::noiseGate.size() <= instance)
        SFXCore::noiseGate.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 7);
        SFXCore::noiseGate[instance].changepar(1, atoi2(params[0].c_str()));
        SFXCore::noiseGate[instance].changepar(2, atoi2(params[1].c_str()));
        SFXCore::noiseGate[instance].changepar(3, atoi2(params[2].c_str()));
        SFXCore::noiseGate[instance].changepar(4, atoi2(params[3].c_str()));
        SFXCore::noiseGate[instance].changepar(5, atoi2(params[4].c_str()));
        SFXCore::noiseGate[instance].changepar(6, atoi2(params[5].c_str()));
        SFXCore::noiseGate[instance].changepar(7, atoi2(params[6].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Derelict:
      if (SFXCore::derelict.size() <= instance)
        SFXCore::derelict.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 12);
        SFXCore::derelict[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::derelict[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::derelict[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::derelict[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::derelict[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::derelict[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::derelict[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::derelict[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::derelict[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::derelict[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::derelict[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::derelict[instance].changepar(11, atoi2(params[11].c_str()));
      }
      return;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::AnalogPhaser:
      if (SFXCore::analogPhaser.size() <= instance)
        SFXCore::analogPhaser.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::analogPhaser[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::analogPhaser[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::analogPhaser[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::analogPhaser[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::analogPhaser[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::analogPhaser[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::analogPhaser[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::analogPhaser[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::analogPhaser[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::analogPhaser[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::analogPhaser[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::analogPhaser[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::analogPhaser[instance].changepar(12, atoi2(params[12].c_str()));
      }
      return;
    case SfxCoreRakarrack::Valve:
      if (SFXCore::valve.size() <= instance)
        SFXCore::valve.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::valve[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::valve[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::valve[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::valve[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::valve[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::valve[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::valve[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::valve[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::valve[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::valve[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::valve[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::valve[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::valve[instance].changepar(12, atoi2(params[12].c_str()));
      }
      return;
    case SfxCoreRakarrack::DualFlange:
      if (SFXCore::dualFlange.size() <= instance)
        SFXCore::dualFlange.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 14);
        SFXCore::dualFlange[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::dualFlange[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::dualFlange[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::dualFlange[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::dualFlange[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::dualFlange[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::dualFlange[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::dualFlange[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::dualFlange[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::dualFlange[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::dualFlange[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::dualFlange[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::dualFlange[instance].changepar(12, atoi2(params[12].c_str()));
        SFXCore::dualFlange[instance].changepar(13, atoi2(params[13].c_str()));
      }
      return;
    case SfxCoreRakarrack::Ring:
      if (SFXCore::ring.size() <= instance)
        SFXCore::ring.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::ring[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::ring[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::ring[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::ring[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::ring[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::ring[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::ring[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::ring[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::ring[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::ring[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::ring[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::ring[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::ring[instance].changepar(12, atoi2(params[12].c_str()));
      }
      return;
    case SfxCoreRakarrack::Exciter:
      if (SFXCore::exciter.size() <= instance)
        SFXCore::exciter.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::exciter[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::exciter[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::exciter[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::exciter[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::exciter[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::exciter[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::exciter[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::exciter[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::exciter[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::exciter[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::exciter[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::exciter[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::exciter[instance].changepar(12, atoi2(params[12].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::DistBand:
      if (SFXCore::distBand.size() <= instance)
        SFXCore::distBand.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 15);
        SFXCore::distBand[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::distBand[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::distBand[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::distBand[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::distBand[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::distBand[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::distBand[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::distBand[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::distBand[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::distBand[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::distBand[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::distBand[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::distBand[instance].changepar(12, atoi2(params[12].c_str()));
        SFXCore::distBand[instance].changepar(13, atoi2(params[13].c_str()));
        SFXCore::distBand[instance].changepar(14, atoi2(params[14].c_str()));
      }
      return;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Arpie:
      if (SFXCore::arpie.size() <= instance)
        SFXCore::arpie.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 11);
        SFXCore::arpie[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::arpie[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::arpie[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::arpie[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::arpie[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::arpie[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::arpie[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::arpie[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::arpie[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::arpie[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::arpie[instance].changepar(10, atoi2(params[10].c_str()));
      }
      return;
    case SfxCoreRakarrack::Expander:
      if (SFXCore::expander.size() <= instance)
        SFXCore::expander.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 7);
        SFXCore::expander[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::expander[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::expander[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::expander[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::expander[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::expander[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::expander[instance].changepar(6, atoi2(params[6].c_str()));
      }
      return;
    case SfxCoreRakarrack::Shuffle:
      if (SFXCore::shuffle.size() <= instance)
        SFXCore::shuffle.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 11);
        SFXCore::shuffle[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::shuffle[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::shuffle[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::shuffle[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::shuffle[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::shuffle[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::shuffle[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::shuffle[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::shuffle[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::shuffle[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::shuffle[instance].changepar(10, atoi2(params[10].c_str()));
      }
      return;
    case SfxCoreRakarrack::Synthfilter:
      if (SFXCore::synthFilter.size() <= instance)
        SFXCore::synthFilter.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 16);
        SFXCore::synthFilter[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::synthFilter[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::synthFilter[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::synthFilter[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::synthFilter[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::synthFilter[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::synthFilter[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::synthFilter[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::synthFilter[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::synthFilter[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::synthFilter[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::synthFilter[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::synthFilter[instance].changepar(12, atoi2(params[12].c_str()));
        SFXCore::synthFilter[instance].changepar(13, atoi2(params[13].c_str()));
        SFXCore::synthFilter[instance].changepar(14, atoi2(params[14].c_str()));
        SFXCore::synthFilter[instance].changepar(15, atoi2(params[15].c_str()));
      }
      return;
    case SfxCoreRakarrack::VaryBand:
      if (SFXCore::varyBand.size() <= instance)
        SFXCore::varyBand.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 11);
        SFXCore::varyBand[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::varyBand[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::varyBand[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::varyBand[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::varyBand[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::varyBand[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::varyBand[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::varyBand[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::varyBand[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::varyBand[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::varyBand[instance].changepar(10, atoi2(params[10].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
#ifdef SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
    case SfxCoreRakarrack::Convolotron:
      if (SFXCore::convolotron.size() <= instance)
        SFXCore::convolotron.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 11);
        SFXCore::convolotron[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::convolotron[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::convolotron[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::convolotron[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::convolotron[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::convolotron[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::convolotron[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::convolotron[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::convolotron[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::convolotron[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::convolotron[instance].changepar(10, atoi2(params[10].c_str()));
      }
      return;
#endif // SHR3D_SFX_CORE_RAKARRACK_CONVOLOTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::MuTroMojo:
      if (SFXCore::muTroMojo.size() <= instance)
        SFXCore::muTroMojo.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 18);
        SFXCore::muTroMojo[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::muTroMojo[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::muTroMojo[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::muTroMojo[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::muTroMojo[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::muTroMojo[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::muTroMojo[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::muTroMojo[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::muTroMojo[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::muTroMojo[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::muTroMojo[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::muTroMojo[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::muTroMojo[instance].changepar(12, atoi2(params[12].c_str()));
        SFXCore::muTroMojo[instance].changepar(13, atoi2(params[13].c_str()));
        SFXCore::muTroMojo[instance].changepar(14, atoi2(params[14].c_str()));
        SFXCore::muTroMojo[instance].changepar(15, atoi2(params[15].c_str()));
        SFXCore::muTroMojo[instance].changepar(16, atoi2(params[16].c_str()));
        SFXCore::muTroMojo[instance].changepar(17, atoi2(params[17].c_str()));
      }
      return;
    case SfxCoreRakarrack::Echoverse:
      if (SFXCore::echoverse.size() <= instance)
        SFXCore::echoverse.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 10);
        SFXCore::echoverse[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::echoverse[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::echoverse[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::echoverse[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::echoverse[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::echoverse[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::echoverse[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::echoverse[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::echoverse[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::echoverse[instance].changepar(9, atoi2(params[9].c_str()));
      }
      return;
    case SfxCoreRakarrack::CoilCrafter:
      if (SFXCore::coilCrafter.size() <= instance)
        SFXCore::coilCrafter.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 9);
        SFXCore::coilCrafter[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::coilCrafter[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::coilCrafter[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::coilCrafter[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::coilCrafter[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::coilCrafter[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::coilCrafter[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::coilCrafter[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::coilCrafter[instance].changepar(8, atoi2(params[8].c_str()));
      }
      return;
    case SfxCoreRakarrack::ShelfBoost:
      if (SFXCore::shelfBoost.size() <= instance)
        SFXCore::shelfBoost.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 5);
        SFXCore::shelfBoost[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::shelfBoost[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::shelfBoost[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::shelfBoost[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::shelfBoost[instance].changepar(4, atoi2(params[4].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Vocoder:
      if (SFXCore::vocoder.size() <= instance)
        SFXCore::vocoder.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 7);
        SFXCore::vocoder[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::vocoder[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::vocoder[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::vocoder[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::vocoder[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::vocoder[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::vocoder[instance].changepar(6, atoi2(params[6].c_str()));
      }
      return;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Sustainer:
      if (SFXCore::sustainer.size() <= instance)
        SFXCore::sustainer.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 2);
        SFXCore::sustainer[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::sustainer[instance].changepar(1, atoi2(params[1].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Sequence:
      if (SFXCore::sequence.size() <= instance)
        SFXCore::sequence.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 15);
        SFXCore::sequence[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::sequence[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::sequence[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::sequence[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::sequence[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::sequence[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::sequence[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::sequence[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::sequence[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::sequence[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::sequence[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::sequence[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::sequence[instance].changepar(12, atoi2(params[12].c_str()));
        SFXCore::sequence[instance].changepar(13, atoi2(params[13].c_str()));
        SFXCore::sequence[instance].changepar(14, atoi2(params[14].c_str()));
      }
      return;
    case SfxCoreRakarrack::Shifter:
      if (SFXCore::shifter.size() <= instance)
        SFXCore::shifter.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 10);
        SFXCore::shifter[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::shifter[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::shifter[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::shifter[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::shifter[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::shifter[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::shifter[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::shifter[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::shifter[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::shifter[instance].changepar(9, atoi2(params[9].c_str()));
      }
      return;
    case SfxCoreRakarrack::StompBox:
      if (SFXCore::stompBox.size() <= instance)
        SFXCore::stompBox.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 6);
        SFXCore::stompBox[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::stompBox[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::stompBox[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::stompBox[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::stompBox[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::stompBox[instance].changepar(5, atoi2(params[5].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
    case SfxCoreRakarrack::Reverbtron:
      if (SFXCore::reverbtron.size() <= instance)
        SFXCore::reverbtron.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 16);
        SFXCore::reverbtron[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::reverbtron[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::reverbtron[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::reverbtron[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::reverbtron[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::reverbtron[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::reverbtron[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::reverbtron[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::reverbtron[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::reverbtron[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::reverbtron[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::reverbtron[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::reverbtron[instance].changepar(12, atoi2(params[12].c_str()));
        SFXCore::reverbtron[instance].changepar(13, atoi2(params[13].c_str()));
        SFXCore::reverbtron[instance].changepar(14, atoi2(params[14].c_str()));
        SFXCore::reverbtron[instance].changepar(15, atoi2(params[15].c_str()));
      }
      return;
#endif // SHR3D_SFX_CORE_RAKARRACK_REVERBTRON
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::Echotron:
      if (SFXCore::echotron.size() <= instance)
        SFXCore::echotron.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 16);
        SFXCore::echotron[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::echotron[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::echotron[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::echotron[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::echotron[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::echotron[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::echotron[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::echotron[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::echotron[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::echotron[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::echotron[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::echotron[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::echotron[instance].changepar(12, atoi2(params[12].c_str()));
        SFXCore::echotron[instance].changepar(13, atoi2(params[13].c_str()));
        SFXCore::echotron[instance].changepar(14, atoi2(params[14].c_str()));
        SFXCore::echotron[instance].changepar(15, atoi2(params[15].c_str()));
      }
      return;
#ifdef SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::StereoHarm:
      if (SFXCore::stereoHarm.size() <= instance)
        SFXCore::stereoHarm.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 12);
        SFXCore::stereoHarm[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::stereoHarm[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::stereoHarm[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::stereoHarm[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::stereoHarm[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::stereoHarm[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::stereoHarm[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::stereoHarm[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::stereoHarm[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::stereoHarm[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::stereoHarm[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::stereoHarm[instance].changepar(11, atoi2(params[11].c_str()));
      }
      return;
#endif // SHR3D_SFX_CORE_RAKARRACK_LIBSAMPLERATE
    case SfxCoreRakarrack::CompBand:
      if (SFXCore::compBand.size() <= instance)
        SFXCore::compBand.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 13);
        SFXCore::compBand[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::compBand[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::compBand[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::compBand[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::compBand[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::compBand[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::compBand[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::compBand[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::compBand[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::compBand[instance].changepar(9, atoi2(params[9].c_str()));
        SFXCore::compBand[instance].changepar(10, atoi2(params[10].c_str()));
        SFXCore::compBand[instance].changepar(11, atoi2(params[11].c_str()));
        SFXCore::compBand[instance].changepar(12, atoi2(params[12].c_str()));
      }
      return;
    case SfxCoreRakarrack::OpticalTrem:
      if (SFXCore::opticalTrem.size() <= instance)
        SFXCore::opticalTrem.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 6);
        SFXCore::opticalTrem[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::opticalTrem[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::opticalTrem[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::opticalTrem[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::opticalTrem[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::opticalTrem[instance].changepar(5, atoi2(params[5].c_str()));
      }
      return;
    case SfxCoreRakarrack::Vibe:
      if (SFXCore::vibe.size() <= instance)
        SFXCore::vibe.resize(instance + 1);
      if (params.size() > 0)
      {
        ASSERT(params.size() == 10);
        SFXCore::vibe[instance].changepar(0, atoi2(params[0].c_str()));
        SFXCore::vibe[instance].changepar(1, atoi2(params[1].c_str()));
        SFXCore::vibe[instance].changepar(2, atoi2(params[2].c_str()));
        SFXCore::vibe[instance].changepar(3, atoi2(params[3].c_str()));
        SFXCore::vibe[instance].changepar(4, atoi2(params[4].c_str()));
        SFXCore::vibe[instance].changepar(5, atoi2(params[5].c_str()));
        SFXCore::vibe[instance].changepar(6, atoi2(params[6].c_str()));
        SFXCore::vibe[instance].changepar(7, atoi2(params[7].c_str()));
        SFXCore::vibe[instance].changepar(8, atoi2(params[8].c_str()));
        SFXCore::vibe[instance].changepar(9, atoi2(params[9].c_str()));
      }
      return;
    default:
      unreachable();
    }
  }
#endif // SHR3D_SFX_CORE_RAKARRACK
#ifdef SHR3D_SFX_CORE_AIRWINDOWS
  case SfxSystem::coreAirWindows:
  {
    const SfxCoreAirWindows_ sfxCoreAirWindows = SfxCoreAirWindows_(sfxId.sfxIndex);

    std::vector<f32> paramsF32(params.size());
    for (i32 i = 0; i < params.size(); ++i)
      paramsF32[i] = f32(atof(reinterpret_cast<const char*>(params[i].c_str())));

    SfxCoreAirWindows::loadParameters(sfxCoreAirWindows, instance, paramsF32.data(), i32(paramsF32.size()));
    return;
  }
#endif // SHR3D_SFX_CORE_AIRWINDOWS
  default:
    unreachable();
  }
  unreachable();
}

#ifdef SHR3D_SFX_CORE_AIRWINDOWS
i32 SFXCore::getParameterCount(const SfxCoreAirWindows_ sfxCoreAirWindows)
{
  return SfxCoreAirWindows::getParameterCount(sfxCoreAirWindows);
}
f32 SFXCore::getParameter(const SfxCoreAirWindows_ sfxCoreAirWindows, i32 instance, i32 param)
{
  return SfxCoreAirWindows::getParameter(sfxCoreAirWindows, instance, param);
}
void SFXCore::setParameter(const SfxCoreAirWindows_ sfxCoreAirWindows, i32 instance, i32 param, f32 value)
{
  SfxCoreAirWindows::setParameter(sfxCoreAirWindows, instance, param, value);
}
void SFXCore::getParameterLabel(const SfxCoreAirWindows_ sfxCoreAirWindows, i32 instance, i32 param, char* text)
{
  SfxCoreAirWindows::getParameterLabel(sfxCoreAirWindows, instance, param, text);
}
void SFXCore::getParameterName(const SfxCoreAirWindows_ sfxCoreAirWindows, i32 instance, i32 param, char* text)
{
  SfxCoreAirWindows::getParameterName(sfxCoreAirWindows, instance, param, text);
}
void SFXCore::getParameterDisplay(const SfxCoreAirWindows_ sfxCoreAirWindows, i32 instance, i32 param, char* text)
{
  SfxCoreAirWindows::getParameterDisplay(sfxCoreAirWindows, instance, param, text);
}
#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif // SHR3D_SFX_CORE