/*
* AirwinConsolidated - an adaptation of the airwindows effect suite
* for various open source clients
*
* This source released under the MIT License, found in ~/LICENSE.md.
*
* Copyright 2023 by the authors as described in the github transaction log
*/

#include "airwin_consolidated_base.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../../../global.h"

#include <iostream>

float getSampleRate()
{
  return f32(sampleRate());
}

void float2string(float f, char* txt, int n)
{
  snprintf(txt, n, "%8.4f", f);
}

void int2string(int i, char* t, size_t num)
{
  snprintf(t, num, "%d", i);
}

void dB2string(float value, char* t, size_t num)
{
  if (value <= 0.00001) // -100 dB, show -inf from that point onwards
    strncpy(t, "-inf", num);
  else
    float2string((float)(20.0 * log10(value)), t, num);
}

#endif // SHR3D_SFX_CORE_AIRWINDOWS
