/*
 * AirwinConslidated - an adaptation of the airwindows effect suite for
 * open source clients
 *
 * This source released under the MIT License, found in ~/LICENSE.md.
 *
 * Copyright 2023 by the authors as described in the github transaction log
 */

#ifndef AIRWIN_CONSOLIDATED_AIRWINBASE_H
#define AIRWIN_CONSOLIDATED_AIRWINBASE_H

#include "../../../configuration.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <math.h>
#include <stdint.h>
#include <string.h>

static constexpr int32_t kVstMaxParamStrLen{32};

struct SfxCoreExtensionV1
{
  virtual void processBlock(float** inputs, float** outputs, int sampleFrames) = 0;

  virtual int getParameterCount() const = 0;
  virtual float getParameter(int index) = 0; // get the parameter value at the specified index
  virtual void setParameter(int index, float value) = 0; // set the parameter at index to value
  virtual void getParameterLabel(int index, char* text) = 0; // label for the parameter (eg dB)
  virtual void getParameterName(int index, char* text) = 0; // label for the parameter (eg dB)
  virtual void getParameterDisplay(int index, char* text) = 0; // text description of the current value
};

float getSampleRate();
void float2string(float f, char *txt, int n);
void int2string(int i, char* t, size_t num);
void dB2string(float value, char* t, size_t num);

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
