/* ========================================
 *  ADClip7 - ADClip7.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "ADClip7.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::ADClip7 {

ADClip7::ADClip7()
{
	A = 0.0;
	B = 0.5;
	C = 0.5;
	D = 0.0;

	lastSampleL = 0.0;
	lastSampleR = 0.0;
	for(int count = 0; count < 22199; count++) {bL[count] = 0; bR[count] = 0;}
	gcount = 0;
	lowsL = 0;
	lowsR = 0;
	refclipL = 0.99;
	refclipR = 0.99;
	iirLowsAL = 0.0;
	iirLowsAR = 0.0;
	iirLowsBL = 0.0;	
	iirLowsBR = 0.0;	
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int ADClip7::getParameterCount() const
{
	return kNumParameters;
}

void ADClip7::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float ADClip7::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void ADClip7::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Boost", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Soften", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Enhance", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Mode", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void ADClip7::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A*18.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: switch((int)( D * 2.999 )) //0 to almost edge of # of params
		{case 0: strncpy (text, "Normal", kVstMaxParamStrLen); break;
		 case 1: strncpy (text, "Atten", kVstMaxParamStrLen); break;
		 case 2: strncpy (text, "Clips", kVstMaxParamStrLen); break;
		 default: break; // unknown parameter, shouldn't happen!
		} break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void ADClip7::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
