/* ========================================
 *  ADClip8 - ADClip8.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "ADClip8.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::ADClip8 {

ADClip8::ADClip8()
{
	A = 0.0;
	B = 0.883;
	C = 0.0;
	for (int stage = 0; stage < 8; stage++) {
		lastSampleL[stage] = 0.0;
		lastSampleR[stage] = 0.0;
		wasPosClipL[stage] = false;
		wasPosClipR[stage] = false;
		wasNegClipL[stage] = false;
		wasNegClipR[stage] = false;
		for (int x = 0; x < 16; x++) {intermediateL[x][stage] = 0.0;intermediateR[x][stage] = 0.0;}
	}
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int ADClip8::getParameterCount() const
{
	return kNumParameters;
}

void ADClip8::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float ADClip8::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
		default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void ADClip8::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Boost", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Ceiling", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Mode", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void ADClip8::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A*18.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: switch((int)( C * 7.999 )) //0 to almost edge of # of params
		{case 0: strncpy (text, "Normal", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Atten", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "Clips", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Afterbr", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "Explode", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "Nuke", kVstMaxParamStrLen); break;
			case 6: strncpy (text, "Apocaly", kVstMaxParamStrLen); break;
			case 7: strncpy (text, "Apothes", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void ADClip8::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
