/* ========================================
 *  AQuickVoiceClip - AQuickVoiceClip.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "AQuickVoiceClip.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::AQuickVoiceClip {

AQuickVoiceClip::AQuickVoiceClip()
{
	A = 0.42f;
	LataLast6Sample = LataLast5Sample = LataLast4Sample = 0.0;
	LataLast3Sample = LataLast2Sample = LataLast1Sample = 0.0;
	LataHalfwaySample = LataHalfDrySample = LataHalfDiffSample = 0.0;
	LataDrySample = LataDiffSample = LataPrevDiffSample = 0.0;
	
	RataLast6Sample = RataLast5Sample = RataLast4Sample = 0.0;
	RataLast3Sample = RataLast2Sample = RataLast1Sample = 0.0;
	RataHalfwaySample = RataHalfDrySample = RataHalfDiffSample = 0.0;
	RataDrySample = RataDiffSample = RataPrevDiffSample = 0.0;
	
	LlastSample = 0.0;
	LlastOutSample = 0.0;
	LlastOut2Sample = 0.0;
	LlastOut3Sample = 0.0;
	LlpDepth = 0.0;
	Lovershoot = 0.0;
	Loverall = 0;
	LiirSampleA = 0.0;
	LiirSampleB = 0.0;
	LiirSampleC = 0.0;
	LiirSampleD = 0.0;

	RlastSample = 0.0;
	RlastOutSample = 0.0;
	RlastOut2Sample = 0.0;
	RlastOut3Sample = 0.0;
	RlpDepth = 0.0;
	Rovershoot = 0.0;
	Roverall = 0;
	RiirSampleA = 0.0;
	RiirSampleB = 0.0;
	RiirSampleC = 0.0;
	RiirSampleD = 0.0;
	flip = true;
	
	ataK1 = -0.646; //first FIR shaping of interpolated sample, brightens
	ataK2 = 0.311; //second FIR shaping of interpolated sample, thickens
	ataK6 = -0.093; //third FIR shaping of interpolated sample, brings air
	ataK7 = 0.057; //fourth FIR shaping of interpolated sample, thickens
	ataK8 = -0.023; //fifth FIR shaping of interpolated sample, brings air
	ataK3 = 0.114; //add raw to interpolated dry, toughens
	ataK4 = 0.886; //remainder of interpolated dry, adds up to 1.0
	ataK5 = 0.431; //subtract this much prev. diff sample, brightens.  0.431 becomes flat
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int AQuickVoiceClip::getParameterCount() const
{
	return kNumParameters;
}

void AQuickVoiceClip::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float AQuickVoiceClip::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void AQuickVoiceClip::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Highpass", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void AQuickVoiceClip::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((pow(A,3)*2070)+30, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void AQuickVoiceClip::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "hz", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
