/* ========================================
 *  Acceleration2 - Acceleration2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Acceleration2_Acceleration2_H
#define __Acceleration2_Acceleration2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Acceleration2 {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Acceleration2 final : public SfxCoreExtensionV1
{
public:
    Acceleration2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	
	double lastSampleL;
	double sL[34];
	double m1L;
	double m2L;
	
	double lastSampleR;
	double sR[34];
	double m1R;
	double m2R;
	
	double biquadA[11];
	double biquadB[11]; //note that this stereo form doesn't require L and R forms!
	//This is because so much of it is coefficients etc. that are the same on both channels.
	//So the stored samples are in 7-8 and 9-10, and freq/res/coefficients serve both.
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
