/* ========================================
 *  Air - Air.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Air.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Air {

Air::Air()
{
	airPrevAL = 0.0;
	airEvenAL = 0.0;
	airOddAL = 0.0;
	airFactorAL = 0.0;
	airPrevBL = 0.0;
	airEvenBL = 0.0;
	airOddBL = 0.0;
	airFactorBL = 0.0;
	airPrevCL = 0.0;
	airEvenCL = 0.0;
	airOddCL = 0.0;
	airFactorCL = 0.0;
	tripletPrevL = 0.0;
	tripletMidL = 0.0;
	tripletAL = 0.0;
	tripletBL = 0.0;
	tripletCL = 0.0;
	tripletFactorL = 0.0;

	airPrevAR = 0.0;
	airEvenAR = 0.0;
	airOddAR = 0.0;
	airFactorAR = 0.0;
	airPrevBR = 0.0;
	airEvenBR = 0.0;
	airOddBR = 0.0;
	airFactorBR = 0.0;
	airPrevCR = 0.0;
	airEvenCR = 0.0;
	airOddCR = 0.0;
	airFactorCR = 0.0;
	tripletPrevR = 0.0;
	tripletMidR = 0.0;
	tripletAR = 0.0;
	tripletBR = 0.0;
	tripletCR = 0.0;
	tripletFactorR = 0.0;
	
	flipA = false;
	flipB = false;
	flop = false;
	count = 1;

	A = 0.5;
	B = 0.5;
	C = 0.5;
	D = 0.0;
	E = 1.0;
	F = 1.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Air::getParameterCount() const
{
	return kNumParameters;
}

void Air::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break; //percent. Using this value, it'll be 0-100 everywhere
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Air::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Air::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "22K tap", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "15K tap", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "11K tap", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "filters Q", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "Output Level", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Air::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C*2.0)-1.0, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;		
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;		
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break;		
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Air::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, " ", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, " ", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
