/* ========================================
 *  AtmosphereChannel - AtmosphereChannel.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "AtmosphereChannel.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::AtmosphereChannel {

AtmosphereChannel::AtmosphereChannel()
{
	A = 1.0;

	gainchase = -90.0;
	settingchase = -90.0;
	chasespeed = 350.0;
	
	fpNShapeL = 0.0;
	lastSampleAL = 0.0;
	lastSampleBL = 0.0;
	lastSampleCL = 0.0;
	lastSampleDL = 0.0;
	lastSampleEL = 0.0;
	lastSampleFL = 0.0;
	lastSampleGL = 0.0;
	lastSampleHL = 0.0;
	lastSampleIL = 0.0;
	lastSampleJL = 0.0;
	lastSampleKL = 0.0;
	lastSampleLL = 0.0;
	lastSampleML = 0.0;
	
	fpNShapeR = 0.0;
	lastSampleAR = 0.0;
	lastSampleBR = 0.0;
	lastSampleCR = 0.0;
	lastSampleDR = 0.0;
	lastSampleER = 0.0;
	lastSampleFR = 0.0;
	lastSampleGR = 0.0;
	lastSampleHR = 0.0;
	lastSampleIR = 0.0;
	lastSampleJR = 0.0;
	lastSampleKR = 0.0;
	lastSampleLR = 0.0;
	lastSampleMR = 0.0;
	
	thresholdA = 0.618033988749894;
	thresholdB = 0.679837387624884;
	thresholdC = 0.747821126387373;
	thresholdD = 0.82260323902611;
	thresholdE = 0.904863562928721;
	thresholdF = 0.995349919221593;
	thresholdG = 1.094884911143752;
	thresholdH = 1.204373402258128;
	thresholdI = 1.32481074248394;
	thresholdJ = 1.457291816732335;
	thresholdK = 1.603020998405568;
	thresholdL = 1.763323098246125;
	thresholdM = 1.939655408070737;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int AtmosphereChannel::getParameterCount() const
{
	return kNumParameters;
}

void AtmosphereChannel::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float AtmosphereChannel::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void AtmosphereChannel::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Input", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void AtmosphereChannel::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void AtmosphereChannel::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
