/* ========================================
 *  AtmosphereChannel - AtmosphereChannel.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __AtmosphereChannel_AtmosphereChannel_H
#define __AtmosphereChannel_AtmosphereChannel_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::AtmosphereChannel {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class AtmosphereChannel final : public SfxCoreExtensionV1
{
public:
    AtmosphereChannel();
    ~AtmosphereChannel();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double gainchase;
	double settingchase;
	double chasespeed;		
	
	uint32_t fpdL;
	uint32_t fpdR;
	double fpNShapeL;
	double lastSampleAL;
	double lastSampleBL;
	double lastSampleCL;
	double lastSampleDL;
	double lastSampleEL;
	double lastSampleFL;
	double lastSampleGL;
	double lastSampleHL;
	double lastSampleIL;
	double lastSampleJL;
	double lastSampleKL;
	double lastSampleLL;
	double lastSampleML;
	
	double fpNShapeR;
	double lastSampleAR;
	double lastSampleBR;
	double lastSampleCR;
	double lastSampleDR;
	double lastSampleER;
	double lastSampleFR;
	double lastSampleGR;
	double lastSampleHR;
	double lastSampleIR;
	double lastSampleJR;
	double lastSampleKR;
	double lastSampleLR;
	double lastSampleMR;
	
	double thresholdA;
	double thresholdB;
	double thresholdC;
	double thresholdD;
	double thresholdE;
	double thresholdF;
	double thresholdG;
	double thresholdH;
	double thresholdI;
	double thresholdJ;
	double thresholdK;
	double thresholdL;
	double thresholdM;
	
    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
