/* ========================================
 *  AverMatrix - AverMatrix.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "AverMatrix.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::AverMatrix {

AverMatrix::AverMatrix()
{
	A = 0.0;
	B = 0.0;
	C = 1.0;
	for(int x = 0; x < 11; x++) {
		f[x] = 0.0;
		for (int y = 0; y < 11; y++) {
			bL[x][y] = 0.0; bR[x][y] = 0.0;
		}
	}

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int AverMatrix::getParameterCount() const
{
  return kNumParameters;
}

void AverMatrix::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float AverMatrix::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void AverMatrix::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Average", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Depth", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Inv/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void AverMatrix::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A * 9.0)+1.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B * 9.0)+1.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C * 2.0)-1.0, text, kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void AverMatrix::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "taps", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "poles", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
