/* ========================================
 *  Average - Average.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Average.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Average {

Average::Average()
{
	A = 0.0;
	B = 1.0;
	
	for(int count = 0; count < 11; count++) {bL[count] = 0.0; bR[count] = 0.0; f[count] = 0.0;}
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Average::getParameterCount() const
{
  return kNumParameters;
}

void Average::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break; //percent. Using this value, it'll be 0-100 everywhere
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Average::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Average::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Average", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Average::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A * 9.0)+1.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break; //also display 0-1 as percent
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Average::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "taps", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, " ", kVstMaxParamStrLen); break; //the percent
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
