/* ========================================
 *  Balanced - Balanced.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Balanced.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Balanced {

Balanced::Balanced()
{
	A = 0.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Balanced::getParameterCount() const
{
  return kNumParameters;
}

void Balanced::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
		default: break; // unknown parameter, shouldn't happen!
    }
}

float Balanced::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Balanced::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "BitShift", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Balanced::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: int2string ((int)(A * 8), text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Balanced::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "bits", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
