/* ========================================
 *  BassDrive - BassDrive.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BassDrive_BassDrive_H
#define __BassDrive_BassDrive_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BassDrive {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class BassDrive final : public SfxCoreExtensionV1
{
public:
    BassDrive();
    ~BassDrive();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	double presenceInAL[7];
	double presenceOutAL[7];
	double highInAL[7];
	double highOutAL[7];
	double midInAL[7];
	double midOutAL[7];
	double lowInAL[7];
	double lowOutAL[7];
	double presenceInBL[7];
	double presenceOutBL[7];
	double highInBL[7];
	double highOutBL[7];
	double midInBL[7];
	double midOutBL[7];
	double lowInBL[7];
	double lowOutBL[7];
	
	double presenceInAR[7];
	double presenceOutAR[7];
	double highInAR[7];
	double highOutAR[7];
	double midInAR[7];
	double midOutAR[7];
	double lowInAR[7];
	double lowOutAR[7];
	double presenceInBR[7];
	double presenceOutBR[7];
	double highInBR[7];
	double highOutBR[7];
	double midInBR[7];
	double midOutBR[7];
	double lowInBR[7];
	double lowOutBR[7];
	
	bool flip;
	
    float A;
    float B;
    float C;
    float D;
    float E; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
