/* ========================================
 *  BassKit - BassKit.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BassKit_BassKit_H
#define __BassKit_BassKit_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BassKit {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class BassKit final : public SfxCoreExtensionV1
{
public:
    BassKit();
    ~BassKit();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
   
	double iirDriveSampleA;
	double iirDriveSampleB;
	double iirDriveSampleC;
	double iirDriveSampleD;
	double iirDriveSampleE;
	double iirDriveSampleF;
	bool flip; //drive things
	
	int bflip;
	bool WasNegative;
	bool SubOctave;
	double iirHeadBumpA;
	double iirHeadBumpB;
	double iirHeadBumpC;
	
	double iirSubBumpA;
	double iirSubBumpB;
	double iirSubBumpC;
	
	double lastHeadBump;
	double lastSubBump;
	
	double iirSampleA;
	double iirSampleB;
	double iirSampleC;
	double iirSampleD;
	double iirSampleE;
	double iirSampleF;
	double iirSampleG;
	double iirSampleH;
	double iirSampleI;
	double iirSampleJ;
	double iirSampleK;
	double iirSampleL;
	double iirSampleM;
	double iirSampleN;
	double iirSampleO;
	double iirSampleP;
	double iirSampleQ;
	double iirSampleR;
	double iirSampleS;
	double iirSampleT;
	double iirSampleU;
	double iirSampleV;
	double iirSampleW;
	double iirSampleX;
	double iirSampleY;
	double iirSampleZ;		
	double oscGate;	
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
