/* ========================================
 *  Baxandall - Baxandall.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Baxandall.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Baxandall {

Baxandall::Baxandall()
{
	A = 0.5;
	B = 0.5;
	C = 0.5;
	for (int x = 0; x < 9; x++) {
		trebleAL[x] = 0.0;
		trebleBL[x] = 0.0;
		bassAL[x] = 0.0;
		bassBL[x] = 0.0;
		trebleAR[x] = 0.0;
		trebleBR[x] = 0.0;
		bassAR[x] = 0.0;
		bassBR[x] = 0.0;
	}
	flip = false;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Baxandall::getParameterCount() const
{
  return kNumParameters;
}

void Baxandall::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Baxandall::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Baxandall::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Treble", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Bass", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Baxandall::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*30.0)-15.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*30.0)-15.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C*30.0)-15.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Baxandall::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "dB", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
