/* ========================================
 *  Baxandall2 - Baxandall2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Baxandall2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Baxandall2 {

Baxandall2::Baxandall2()
{
	A = 0.5;
	B = 0.5;
	for (int x = 0; x < 9; x++) {
		trebleAL[x] = 0.0;
		trebleBL[x] = 0.0;
		bassAL[x] = 0.0;
		bassBL[x] = 0.0;
		trebleAR[x] = 0.0;
		trebleBR[x] = 0.0;
		bassAR[x] = 0.0;
		bassBR[x] = 0.0;
	}
	flip = false;	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Baxandall2::getParameterCount() const
{
	return kNumParameters;
}

void Baxandall2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Baxandall2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Baxandall2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Treble", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Bass", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Baxandall2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*48.0)-24.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string ((B*48.0)-24.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Baxandall2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "dB", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
