/* ========================================
 *  Biquad2 - Biquad2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Biquad2_Biquad2_H
#define __Biquad2_Biquad2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Biquad2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class Biquad2 final : public SfxCoreExtensionV1
{
public:
    Biquad2();
    ~Biquad2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double biquad[15]; //note that this stereo form doesn't require L and R forms!
	//This is because so much of it is coefficients etc. that are the same on both channels.
	//So the stored samples are in 7-8-9-10 and 11-12-13-14, and freq/res/coefficients serve both.
	
	double bL[11];
	double bR[11];
	double f[11];		
	double frequencychase;
	double resonancechase;
	double outputchase;
	double wetchase;
	double frequencysetting;
	double resonancesetting;
	double outputsetting;
	double wetsetting;
	double chasespeed;

	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
