/* ========================================
 *  BiquadHiLo - BiquadHiLo.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BiquadHiLo_BiquadHiLo_H
#define __BiquadHiLo_BiquadHiLo_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BiquadHiLo {
enum {
	kParamA =0,
	kParamB =1,
  kNumParameters = 2
}; //


class BiquadHiLo final : public SfxCoreExtensionV1
{
public:
    BiquadHiLo();
    ~BiquadHiLo();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
    float A;
    float B;
	
	enum {
		hilp_freq, hilp_temp,
		hilp_a0, hilp_a1, hilp_b1, hilp_b2,
		hilp_c0, hilp_c1, hilp_d1, hilp_d2,
		hilp_e0, hilp_e1, hilp_f1, hilp_f2,
		hilp_aL1, hilp_aL2, hilp_aR1, hilp_aR2,
		hilp_cL1, hilp_cL2, hilp_cR1, hilp_cR2,
		hilp_eL1, hilp_eL2, hilp_eR1, hilp_eR2,
		hilp_total
	};
	double highpass[hilp_total];
	double lowpass[hilp_total];	

	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
