/* ========================================
 *  BitGlitter - BitGlitter.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "BitGlitter.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::BitGlitter {

BitGlitter::BitGlitter()
{
	A = 0.5;
	B = 0.0;
	C = 0.5;
	D = 1.0;

		fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;

	ataLastSampleL = 0.0;
	ataHalfwaySampleL = 0.0;
	lastSampleL = 0.0;
	heldSampleAL = 0.0;
	positionAL = 0.0;
	heldSampleBL = 0.0;
	positionBL = 0.0;
	lastOutputSampleL = 0.0;

	ataLastSampleR = 0.0;
	ataHalfwaySampleR = 0.0;
	lastSampleR = 0.0;
	heldSampleAR = 0.0;
	positionAR = 0.0;
	heldSampleBR = 0.0;
	positionBR = 0.0;
	lastOutputSampleR = 0.0;	
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int BitGlitter::getParameterCount() const
{
	return kNumParameters;
}

void BitGlitter::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float BitGlitter::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void BitGlitter::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Input", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Glitter", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void BitGlitter::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A * 36.0)-18.0, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C * 36.0)-18.0, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void BitGlitter::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
