/* ========================================
 *  BitGlitter - BitGlitter.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BitGlitter_BitGlitter_H
#define __BitGlitter_BitGlitter_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BitGlitter {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class BitGlitter final : public SfxCoreExtensionV1
{
public:
    BitGlitter();
    ~BitGlitter();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	
	double ataLastSampleL;
	double ataHalfwaySampleL;
	double ataDrySampleL;
	double lastSampleL;
	double heldSampleAL;
	double heldSampleBL;
	double positionAL;
	double positionBL;
	double lastOutputSampleL;

	double ataLastSampleR;
	double ataHalfwaySampleR;
	double ataDrySampleR;
	double lastSampleR;
	double heldSampleAR;
	double heldSampleBR;
	double positionAR;
	double positionBR;
	double lastOutputSampleR;
	//there is no noise shaping on this one, it uses all sorts of quantization to get its sound
	
    float A;
    float B;
    float C;
    float D;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
