/* ========================================
 *  BitShiftGain - BitShiftGain.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "BitShiftGain.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::BitShiftGain {

BitShiftGain::BitShiftGain()
{
	A = 0.5;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int BitShiftGain::getParameterCount() const
{
  return kNumParameters;
}

void BitShiftGain::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float BitShiftGain::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void BitShiftGain::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "BitShift", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void BitShiftGain::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: int2string ((int)((A * 32)-16), text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void BitShiftGain::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "bits", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
