/* ========================================
 *  BitShiftPan - BitShiftPan.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "BitShiftPan.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::BitShiftPan {

BitShiftPan::BitShiftPan()
{
	A = 0.5;
	B = 0.5;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int BitShiftPan::getParameterCount() const
{
  return kNumParameters;
}

void BitShiftPan::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float BitShiftPan::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void BitShiftPan::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Vol", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Pan", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void BitShiftPan::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void BitShiftPan::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
