/* ========================================
 *  BlockParty - BlockParty.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __BlockParty_BlockParty_H
#define __BlockParty_BlockParty_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::BlockParty {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class BlockParty final : public SfxCoreExtensionV1
{
public:
    BlockParty();
    ~BlockParty();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
	
	double muVaryL;
	double muAttackL;
	double muNewSpeedL;
	double muSpeedAL;
	double muSpeedBL;
	double muSpeedCL;
	double muSpeedDL;
	double muSpeedEL;
	double muCoefficientAL;
	double muCoefficientBL;
	double muCoefficientCL;
	double muCoefficientDL;
	double muCoefficientEL;
	double lastCoefficientAL;
	double lastCoefficientBL;
	double lastCoefficientCL;
	double lastCoefficientDL;
	double mergedCoefficientsL;
	double thresholdL;
	double thresholdBL;

	double muVaryR;
	double muAttackR;
	double muNewSpeedR;
	double muSpeedAR;
	double muSpeedBR;
	double muSpeedCR;
	double muSpeedDR;
	double muSpeedER;
	double muCoefficientAR;
	double muCoefficientBR;
	double muCoefficientCR;
	double muCoefficientDR;
	double muCoefficientER;
	double lastCoefficientAR;
	double lastCoefficientBR;
	double lastCoefficientCR;
	double lastCoefficientDR;
	double mergedCoefficientsR;
	double thresholdR;
	double thresholdBR;

	int count;
	bool fpFlip;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
