/* ========================================
 *  BrightAmbience3 - BrightAmbience3.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "BrightAmbience3.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::BrightAmbience3 {

BrightAmbience3::BrightAmbience3()
{
	A = 1.0;
	B = 0.0;
	C = 0.0;
	D = 1.0;
	for(int count = 0; count < 32767; count++) {pL[count] = 0.0; pR[count] = 0.0;}
	feedbackA = feedbackB = 0.0;
	for (int x = 0; x < 9; x++) {figureL[x] = 0.0; figureR[x] = 0.0;}
	for (int c = 0; c < 9; c++) {lastRefL[c] = 0.0;lastRefR[c] = 0.0;}
	cycle = 0;
	gcount = 0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int BrightAmbience3::getParameterCount() const
{
  return kNumParameters;
}

void BrightAmbience3::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float BrightAmbience3::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void BrightAmbience3::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Start", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Length", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Feedback", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void BrightAmbience3::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void BrightAmbience3::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
