/* ========================================
 *  BussColors4 - BussColors4.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "BussColors4.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::BussColors4 {

BussColors4::BussColors4()
{
	A = 0.0;
	B = 0.5;
	C = 0.5;
	D = 1.0;

	for (int count = 0; count < 174; count++) {bL[count] = 0; bR[count] = 0;}
	for (int count = 0; count < 99; count++) {dL[count] = 0; dR[count] = 0;}
	for (int count = 0; count < 34; count++) c[count] = count; //initial setup for 44.1K
	g[1] = pow(10.0, -5.2 / 14.0); //dark
	g[2] = pow(10.0, -6.2 / 14.0); //rock
	g[3] = pow(10.0, -2.9 / 14.0); //lush
	g[4] = pow(10.0, -1.1 / 14.0); //vibe
	g[5] = pow(10.0, -5.1 / 14.0); //holo
	g[6] = pow(10.0, -3.6 / 14.0); //punch
	g[7] = pow(10.0, -2.3 / 14.0); //steel
	g[8] = pow(10.0, -2.9 / 14.0); //tube
	//preset gains for models
	outg[1] = pow(10.0, -0.3 / 14.0); //dark
	outg[2] = pow(10.0, 0.5 / 14.0); //rock
	outg[3] = pow(10.0, -0.7 / 14.0); //lush
	outg[4] = pow(10.0, -0.6 / 14.0); //vibe
	outg[5] = pow(10.0, -0.2 / 14.0); //holo
	outg[6] = pow(10.0, 0.3 / 14.0); //punch
	outg[7] = pow(10.0, 0.1 / 14.0); //steel
	outg[8] = pow(10.0, 0.9 / 14.0); //tube
	//preset gains for models
	controlL = 0;
	controlR = 0;
	slowdynL = 0;
	slowdynR = 0;
	gcount = 0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int BussColors4::getParameterCount() const
{
  return kNumParameters;
}

void BussColors4::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break; //percent. Using this value, it'll be 0-100 everywhere
        case kParamC: C = value; break;
        case kParamD: D = value; break; //this is the popup, stored as a float
        default: break; // unknown parameter, shouldn't happen!
    }
}

float BussColors4::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void BussColors4::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Color", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Input Trim", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output Trim", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void BussColors4::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 7.999 )) //0 to almost edge of # of params
		{case 0: strncpy (text, "Dark", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Rock", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "Lush", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Vibe", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "Holo", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "Punch", kVstMaxParamStrLen); break;
			case 6: strncpy (text, "Steel", kVstMaxParamStrLen); break;
			case 7: strncpy (text, "Tube", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break; //completed A 'popup' parameter, exit
        case kParamB: float2string ((B * 36.0)-18.0, text, kVstMaxParamStrLen); break;
        case kParamC: float2string ((C * 36.0)-18.0, text, kVstMaxParamStrLen); break;
		case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void BussColors4::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
