/* ========================================
 *  CStrip2 - CStrip2.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "CStrip2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::CStrip2 {

CStrip2::CStrip2()
{
	A = 0.5f; //Treble -12 to 12
	B = 0.5f; //Mid -12 to 12
	C = 0.5f; //Bass -12 to 12
	D = 0.5f; //TrebFrq 6.0 log 1 to 16 defaulting to 6K
	E = 0.5f; //BassFrq 100.0 log 30 to 1600 defaulting to 100 hz
	F = 1.0f; //Low Cap
	G = 0.0f; //High Cap
	H = 0.0f; //Compres 0-1
	I = 0.0f; //CompSpd 0-1
	J = 0.33f; //Output
		
	iirHighpassAL = 0.0;
	iirHighpassBL = 0.0;
	iirHighpassCL = 0.0;
	iirHighpassDL = 0.0;
	iirHighpassEL = 0.0;
	iirHighpassFL = 0.0;
	iirLowpassAL = 0.0;
	iirLowpassBL = 0.0;
	iirLowpassCL = 0.0;
	iirLowpassDL = 0.0;
	iirLowpassEL = 0.0;
	iirLowpassFL = 0.0;
	
	iirHighpassAR = 0.0;
	iirHighpassBR = 0.0;
	iirHighpassCR = 0.0;
	iirHighpassDR = 0.0;
	iirHighpassER = 0.0;
	iirHighpassFR = 0.0;
	iirLowpassAR = 0.0;
	iirLowpassBR = 0.0;
	iirLowpassCR = 0.0;
	iirLowpassDR = 0.0;
	iirLowpassER = 0.0;
	iirLowpassFR = 0.0;
	count = 0;
	
	lastSampleL = 0.0;
	last2SampleL = 0.0;
	lastSampleR = 0.0;
	last2SampleR = 0.0;	
	
	iirHighSampleLA = 0.0;
	iirHighSampleLB = 0.0;
	iirHighSampleLC = 0.0;
	iirHighSampleLD = 0.0;
	iirHighSampleLE = 0.0;
	iirLowSampleLA = 0.0;
	iirLowSampleLB = 0.0;
	iirLowSampleLC = 0.0;
	iirLowSampleLD = 0.0;
	iirLowSampleLE = 0.0;
	iirHighSampleL = 0.0;
	iirLowSampleL = 0.0;
	
	iirHighSampleRA = 0.0;
	iirHighSampleRB = 0.0;
	iirHighSampleRC = 0.0;
	iirHighSampleRD = 0.0;
	iirHighSampleRE = 0.0;
	iirLowSampleRA = 0.0;
	iirLowSampleRB = 0.0;
	iirLowSampleRC = 0.0;
	iirLowSampleRD = 0.0;
	iirLowSampleRE = 0.0;
	iirHighSampleR = 0.0;
	iirLowSampleR = 0.0;
	
	tripletLA = 0.0;
	tripletLB = 0.0;
	tripletLC = 0.0;
	tripletFactorL = 0.0;
	tripletRA = 0.0;
	tripletRB = 0.0;
	tripletRC = 0.0;
	tripletFactorR = 0.0;
	flip = false;
	flipthree = 0;
	//end EQ
		
	//begin ButterComp
	controlAposL = 1.0;
	controlAnegL = 1.0;
	controlBposL = 1.0;
	controlBnegL = 1.0;
	targetposL = 1.0;
	targetnegL = 1.0;	
	avgLA = avgLB = 0.0;
	nvgLA = nvgLB = 0.0;
	
	controlAposR = 1.0;
	controlAnegR = 1.0;
	controlBposR = 1.0;
	controlBnegR = 1.0;
	targetposR = 1.0;
	targetnegR = 1.0;	
	avgRA = avgRB = 0.0;
	nvgRA = nvgRB = 0.0;
	//end ButterComp	
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int CStrip2::getParameterCount() const
{
  return kNumParameters;
}

void CStrip2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        case kParamG: G = value; break;
        case kParamH: H = value; break;
        case kParamI: I = value; break;
        case kParamJ: J = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float CStrip2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        case kParamG: return G; break;
        case kParamH: return H; break;
        case kParamI: return I; break;
        case kParamJ: return J; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void CStrip2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Treble", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Mid", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Bass", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "TrebFrq", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "BassFrq", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "LowCap", kVstMaxParamStrLen); break;
		case kParamG: strncpy (text, "HiCap", kVstMaxParamStrLen); break;
		case kParamH: strncpy (text, "Compres", kVstMaxParamStrLen); break;
		case kParamI: strncpy (text, "CompSpd", kVstMaxParamStrLen); break;
		case kParamJ: strncpy (text, "Output", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void CStrip2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*24.0)-12.0, text, kVstMaxParamStrLen); break; //Treble -12 to 12
        case kParamB: float2string ((B*24.0)-12.0, text, kVstMaxParamStrLen); break; //Mid -12 to 12
        case kParamC: float2string ((C*24.0)-12.0, text, kVstMaxParamStrLen); break; //Bass -12 to 12
        case kParamD: float2string ((D*D*15.0)+1.0, text, kVstMaxParamStrLen); break; //Lowpass 16.0K log 1 to 16 defaulting to 16K
        case kParamE: float2string ((E*E*1570.0)+30.0, text, kVstMaxParamStrLen); break; //TrebFrq 6.0 log 1 to 16 defaulting to 6K
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break; //BassFrq 100.0 log 30 to 1600 defaulting to 100 hz
        case kParamG: float2string (G, text, kVstMaxParamStrLen); break; //Hipass 30.0 log 30 to 1600 defaulting to 30
        case kParamH: float2string (H, text, kVstMaxParamStrLen); break; //Gate 0-1
        case kParamI: float2string (I, text, kVstMaxParamStrLen); break; //Compres 0-1
        case kParamJ: float2string (J, text, kVstMaxParamStrLen); break; //CompSpd 0-1
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void CStrip2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "dB", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "Khz", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "hz", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamG: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamH: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamI: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamJ: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
