/* ========================================
 *  Cabs - Cabs.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Cabs.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Cabs {

Cabs::Cabs()
{
	A = 0.0;
	B = 0.66;
	C = 0.33;
	D = 0.66;
	E = 0.33;
	F = 0.5;
	
	ataLast3SampleL = ataLast2SampleL = ataLast1SampleL = 0.0; //begin L
	ataHalfwaySampleL = ataHalfDrySampleL = ataHalfDiffSampleL = 0.0;
	ataAL = ataBL = ataCL = ataDrySampleL = ataDiffSampleL = ataPrevDiffSampleL = 0.0;
	
	for(int count = 0; count < 90; count++) {bL[count] = 0;}
	lastSampleL = 0.0;
	lastHalfSampleL = 0.0;
	lastPostSampleL = 0.0;
	lastPostHalfSampleL = 0.0;
	postPostSampleL = 0.0;
	for(int count = 0; count < 20; count++) {dL[count] = 0;}
	controlL = 0;
	iirHeadBumpAL = 0.0;
	iirHeadBumpBL = 0.0;
	iirHalfHeadBumpAL = 0.0;
	iirHalfHeadBumpBL = 0.0;
	for(int count = 0; count < 6; count++) lastRefL[count] = 0.0; //end L
	
	ataLast3SampleR = ataLast2SampleR = ataLast1SampleR = 0.0; //begin R
	ataHalfwaySampleR = ataHalfDrySampleR = ataHalfDiffSampleR = 0.0;
	ataAR = ataBR = ataCR = ataDrySampleR = ataDiffSampleR = ataPrevDiffSampleR = 0.0;
	
	for(int count = 0; count < 90; count++) {bR[count] = 0;}
	lastSampleR = 0.0;
	lastHalfSampleR = 0.0;
	lastPostSampleR = 0.0;
	lastPostHalfSampleR = 0.0;
	postPostSampleR = 0.0;
	for(int count = 0; count < 20; count++) {dR[count] = 0;}
	controlR = 0;
	iirHeadBumpAR = 0.0;
	iirHeadBumpBR = 0.0;
	iirHalfHeadBumpAR = 0.0;
	iirHalfHeadBumpBR = 0.0;
	for(int count = 0; count < 6; count++) lastRefR[count] = 0.0; //end R
	
	flip = false;
	ataFlip = false;
	gcount = 0;
	cycle = 0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Cabs::getParameterCount() const
{
  return kNumParameters;
}

void Cabs::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        case kParamE: E = value; break;
        case kParamF: F = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Cabs::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        case kParamE: return E; break;
        case kParamF: return F; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Cabs::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "CabType", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Intense", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Rm Loud", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "CabSize", kVstMaxParamStrLen); break;
		case kParamE: strncpy (text, "OffAxis", kVstMaxParamStrLen); break;
		case kParamF: strncpy (text, "Output", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Cabs::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: switch((int)( A * 5.999 )) //0 to almost edge of # of params
		{	case 0: strncpy (text, "HPStack", kVstMaxParamStrLen); break;
			case 1: strncpy (text, "Vintage", kVstMaxParamStrLen); break;
			case 2: strncpy (text, "Boutiqe", kVstMaxParamStrLen); break;
			case 3: strncpy (text, "Large C", kVstMaxParamStrLen); break;
			case 4: strncpy (text, "Small C", kVstMaxParamStrLen); break;
			case 5: strncpy (text, "BassAmp", kVstMaxParamStrLen); break;
			default: break; // unknown parameter, shouldn't happen!
		} break; //E as example 'popup' parameter with four values  */
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        case kParamE: float2string (E, text, kVstMaxParamStrLen); break;
        case kParamF: float2string (F, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Cabs::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamE: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamF: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
