/* ========================================
 *  Cabs - Cabs.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Cabs_Cabs_H
#define __Cabs_Cabs_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Cabs {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
  kNumParameters = 6
}; //


class Cabs final : public SfxCoreExtensionV1
{
public:
    Cabs();
    ~Cabs();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double ataLast3SampleL; //begin L
	double ataLast2SampleL;
	double ataLast1SampleL;
	double ataHalfwaySampleL;
	double ataHalfDrySampleL;
	double ataHalfDiffSampleL;
	double ataAL;
	double ataBL;
	double ataCL;
	double ataDrySampleL;
	double ataDiffSampleL;
	double ataPrevDiffSampleL;
	double bL[90];
	double lastSampleL;
	double lastHalfSampleL;
	double lastPostSampleL;
	double lastPostHalfSampleL;
	double postPostSampleL;
	double dL[21];
	double controlL;
	double iirHeadBumpAL;
	double iirHeadBumpBL;
	double iirHalfHeadBumpAL;
	double iirHalfHeadBumpBL;
	double lastRefL[7]; //end L
	
	double ataLast3SampleR; //begin R
	double ataLast2SampleR;
	double ataLast1SampleR;
	double ataHalfwaySampleR;
	double ataHalfDrySampleR;
	double ataHalfDiffSampleR;
	double ataAR;
	double ataBR;
	double ataCR;
	double ataDrySampleR;
	double ataDiffSampleR;
	double ataPrevDiffSampleR;
	double bR[90];
	double lastSampleR;
	double lastHalfSampleR;
	double lastPostSampleR;
	double lastPostHalfSampleR;
	double postPostSampleR;
	double dR[21];
	double controlR;
	double iirHeadBumpAR;
	double iirHeadBumpBR;
	double iirHalfHeadBumpAR;
	double iirHalfHeadBumpBR;
	double lastRefR[7]; //end R
	
	bool flip;
	bool ataFlip; //end defining of antialiasing variables
	int gcount;
	int cycle;
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
