/* ========================================
 *  Chamber2 - Chamber2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Chamber2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Chamber2 {

Chamber2::Chamber2()
{
	A = 0.34f;
	B = 0.31;
	C = 0.28;
	D = 0.25;
	
	for(int count = 0; count < 9999; count++) {aEL[count] = 0.0;aER[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aFL[count] = 0.0;aFR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aGL[count] = 0.0;aGR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aHL[count] = 0.0;aHR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aAL[count] = 0.0;aAR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aBL[count] = 0.0;aBR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aCL[count] = 0.0;aCR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aDL[count] = 0.0;aDR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aIL[count] = 0.0;aIR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aJL[count] = 0.0;aJR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aKL[count] = 0.0;aKR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aLL[count] = 0.0;aLR[count] = 0.0;}
	for(int count = 0; count < 9999; count++) {aML[count] = 0.0;aMR[count] = 0.0;}
	
	feedbackAL = 0.0; feedbackAR = 0.0;
	feedbackBL = 0.0; feedbackBR = 0.0;
	feedbackCL = 0.0; feedbackCR = 0.0;
	feedbackDL = 0.0; feedbackDR = 0.0;
	previousAL = 0.0; previousAR = 0.0;
	previousBL = 0.0; previousBR = 0.0;
	previousCL = 0.0; previousCR = 0.0;
	previousDL = 0.0; previousDR = 0.0;
	
	for(int count = 0; count < 9; count++) {lastRefL[count] = 0.0;lastRefR[count] = 0.0;}
	
	countI = 1;
	countJ = 1;
	countK = 1;
	countL = 1;
	countM = 1;
	
	countA = 1;
	countB = 1;
	countC = 1;
	countD = 1;	
	
	countE = 1;
	countF = 1;
	countG = 1;
	countH = 1;
	cycle = 0;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Chamber2::getParameterCount() const
{
  return kNumParameters;
}

void Chamber2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Chamber2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Chamber2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Delay", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Regen", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Thick", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Chamber2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Chamber2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
