/* ========================================
 *  Chamber2 - Chamber2.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Chamber2_Chamber2_H
#define __Chamber2_Chamber2_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Chamber2 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
  kNumParameters = 4
}; //


class Chamber2 final : public SfxCoreExtensionV1
{
public:
    Chamber2();
    ~Chamber2();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double aEL[10000];
	double aFL[10000];
	double aGL[10000];
	double aHL[10000];
	double aAL[10000];
	double aBL[10000];
	double aCL[10000];
	double aDL[10000];
	double aIL[10000];
	double aJL[10000];
	double aKL[10000];
	double aLL[10000];
	double aML[10000];
	
	double feedbackAL;
	double feedbackBL;
	double feedbackCL;
	double feedbackDL;
	double previousAL;
	double previousBL;
	double previousCL;
	double previousDL;
	
	double lastRefL[10];
		
	double aER[10000];
	double aFR[10000];
	double aGR[10000];
	double aHR[10000];
	double aAR[10000];
	double aBR[10000];
	double aCR[10000];
	double aDR[10000];
	double aIR[10000];
	double aJR[10000];
	double aKR[10000];
	double aLR[10000];
	double aMR[10000];
	
	double feedbackAR;
	double feedbackBR;
	double feedbackCR;
	double feedbackDR;
	double previousAR;
	double previousBR;
	double previousCR;
	double previousDR;
	
	double lastRefR[10];
	
	int countA, delayA;
	int countB, delayB;
	int countC, delayC;
	int countD, delayD;
	int countE, delayE;
	int countF, delayF;
	int countG, delayG;
	int countH, delayH;
	int countI, delayI;
	int countJ, delayJ;
	int countK, delayK;
	int countL, delayL;
	int countM, delayM;
	int cycle; //all these ints are shared across channels, not duplicated	
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
    float A;
    float B;
    float C;
    float D;	
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
