/* ========================================
 *  Channel4 - Channel4.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Channel4_Channel4_H
#define __Channel4_Channel4_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Channel4 {
enum {
	kParamA = 0,
	kParamB = 1,
  kNumParameters = 2
}; //


class Channel4 final : public SfxCoreExtensionV1
{
public:
    Channel4();
    ~Channel4();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double fpNShapeLA;
	double fpNShapeLB;
	double fpNShapeRA;
	double fpNShapeRB;
	bool fpFlip;
	//default stuff
	double iirSampleLA;
	double iirSampleRA;
	double iirSampleLB;
	double iirSampleRB;
	double lastSampleL;
	double lastSampleR;
	double iirAmount;
	double threshold;
	
	uint32_t fpdL;
	uint32_t fpdR;

    float consoletype;
    float drive; //parameters. Always 0-1, and we scale/alter them elsewhere.
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
