/* ========================================
 *  Channel9 - Channel9.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Channel9_Channel9_H
#define __Channel9_Channel9_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Channel9 {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class Channel9 final : public SfxCoreExtensionV1
{
public:
    Channel9();
    ~Channel9();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double iirSampleLA;
	double iirSampleRA;
	double iirSampleLB;
	double iirSampleRB;
	double lastSampleAL;
	double lastSampleBL;
	double lastSampleCL;
	double lastSampleAR;
	double lastSampleBR;
	double lastSampleCR;
	double biquadA[15];
	double biquadB[15];
	double iirAmount;
	double threshold;
	double cutoff;
	bool flip;

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
