/* ========================================
 *  ClipOnly2 - ClipOnly2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "ClipOnly2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::ClipOnly2 {

ClipOnly2::ClipOnly2()
{
	lastSampleL = 0.0;
	wasPosClipL = false;
	wasNegClipL = false;
	lastSampleR = 0.0;
	wasPosClipR = false;
	wasNegClipR = false;
	for (int x = 0; x < 16; x++) {intermediateL[x] = 0.0; intermediateR[x] = 0.0;}
	//fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	//fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX; //leave off for ClipOnly
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int ClipOnly2::getParameterCount() const
{
	return kNumParameters;
}

void ClipOnly2::setParameter(int index, float value) {
    switch (index) {
		default: break; // unknown parameter, shouldn't happen!
    }
}

float ClipOnly2::getParameter(int index) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void ClipOnly2::getParameterName(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void ClipOnly2::getParameterDisplay(int index, char *text) {
    switch (index) {
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void ClipOnly2::getParameterLabel(int index, char *text) {
    switch (index) {
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
