/* ========================================
 *  Cojones - Cojones.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Cojones_Cojones_H
#define __Cojones_Cojones_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Cojones {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
  kNumParameters = 5
}; //


class Cojones final : public SfxCoreExtensionV1
{
public:
    Cojones();
    ~Cojones();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

	double storedL[2];
	double diffL[6];

	double storedR[2];
	double diffR[6];

    float A;
    float B;
    float C;
    float D;
    float E; //parameters. Always 0-1, and we scale/alter them elsewhere.

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
