/* ========================================
 *  Console4Buss - Console4Buss.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#include "Console4Buss.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Console4Buss {

Console4Buss::Console4Buss()
{
	gain = 1.0;
	lastSampleL = 0.0;
	lastSampleR = 0.0;
	gainchase = -90.0;
	settingchase = -90.0;
	chasespeed = 350.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
}

Console4Buss::~Console4Buss() 
{
}

int Console4Buss::getParameterCount() const
{
  return kNumParameters;
}

void Console4Buss::setParameter(int index, float value) {
    switch (index) {
        case kConsole4BussParam:
            gain = value;
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

float Console4Buss::getParameter(int index) {
    switch (index) {
        case kConsole4BussParam:
            return gain;
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
	return 0.0;
}

void Console4Buss::getParameterName(int index, char *text) {
    switch (index) {
        case kConsole4BussParam:
            strncpy (text, "Trim", kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

void Console4Buss::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kConsole4BussParam:
            float2string (gain, text, kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

void Console4Buss::getParameterLabel(int index, char *text) {
    switch (index) {
        case kConsole4BussParam:
            strncpy (text, " ", kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
