/* ========================================
 *  Console4Channel - Console4Channel.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#include "Console4Channel.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Console4Channel {

Console4Channel::Console4Channel()
{
	gain = 1.0;
	gainchase = -90.0;
	settingchase = -90.0;
	chasespeed = 350.0;
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
    
}

Console4Channel::~Console4Channel() 
{
}

int Console4Channel::getParameterCount() const
{
  return kNumParameters;
}

void Console4Channel::setParameter(int index, float value) {
    switch (index) {
        case kConsole4ChannelParam:
            gain = value;
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

float Console4Channel::getParameter(int index) {
    switch (index) {
        case kConsole4ChannelParam:
            return gain;
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
	return 0.0;
}

void Console4Channel::getParameterName(int index, char *text) {
    switch (index) {
        case kConsole4ChannelParam:
            strncpy (text, "Trim", kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

void Console4Channel::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kConsole4ChannelParam:
            float2string (gain, text, kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

void Console4Channel::getParameterLabel(int index, char *text) {
    switch (index) {
        case kConsole4ChannelParam:
            strncpy (text, " ", kVstMaxParamStrLen);
            break;
        default: // unknown parameter, shouldn't happen!
            break;
    }
}

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
