/* ========================================
 *  ConsoleMCChannel - ConsoleMCChannel.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __ConsoleMCChannel_ConsoleMCChannel_H
#define __ConsoleMCChannel_ConsoleMCChannel_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::ConsoleMCChannel {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
	kParamD = 3,
	kParamE = 4,
	kParamF = 5,
  kNumParameters = 6
}; //


class ConsoleMCChannel final : public SfxCoreExtensionV1
{
public:
    ConsoleMCChannel();
    ~ConsoleMCChannel();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double avgAL;
	double avgAR;
	double avgBL;
	double avgBR;
	double avgCL;
	double avgCR;
	double subAL;
	double subBL;
	double subAR;
	double subBR;
	double pearA[18];
	double pearB[22];
	double mpkL[2005];
	double mpkR[2005];
	double f[66];
	double prevfreqMPeak;
	double prevamountMPeak;
	int mpc;
	double bassA;
	double bassB;
	double gainA;
	double gainB; //smoothed master fader for channel, from Z2 series filter code
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
    float D;
    float E;
    float F;

};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
