/* ========================================
 *  ConsoleMDBuss - ConsoleMDBuss.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __ConsoleMDBuss_ConsoleMDBuss_H
#define __ConsoleMDBuss_ConsoleMDBuss_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::ConsoleMDBuss {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class ConsoleMDBuss final : public SfxCoreExtensionV1
{
public:
    ConsoleMDBuss();
    ~ConsoleMDBuss();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	double lastSinewL;
	double lastSinewR;
	
	double gainA;
	double gainB; //smoothed master fader for channel, from Z2 series filter code
	
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
