/* ========================================
 *  DeEss - DeEss.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __DeEss_DeEss_H
#define __DeEss_DeEss_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::DeEss {
enum {
	kParamA = 0,
	kParamB = 1,
	kParamC = 2,
  kNumParameters = 3
}; //


class DeEss final : public SfxCoreExtensionV1
{
public:
    DeEss();
    ~DeEss();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
	
	double s1L;
	double s2L;
	double s3L;
	double s4L;
	double s5L;
	double s6L;
	double s7L;
	double m1L;
	double m2L;
	double m3L;
	double m4L;
	double m5L;
	double m6L;
	double c1L;
	double c2L;
	double c3L;
	double c4L;
	double c5L;
	double ratioAL;
	double ratioBL;
	double iirSampleAL;
	double iirSampleBL;
	
	double s1R;
	double s2R;
	double s3R;
	double s4R;
	double s5R;
	double s6R;
	double s7R;
	double m1R;
	double m2R;
	double m3R;
	double m4R;
	double m5R;
	double m6R;
	double c1R;
	double c2R;
	double c3R;
	double c4R;
	double c5R;
	double ratioAR;
	double ratioBR;
	double iirSampleAR;
	double iirSampleBR;
	
	
	bool flip;	
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff

    float A;
    float B;
    float C;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
