/* ========================================
 *  Density2 - Density2.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Density2.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Density2 {

Density2::Density2()
{
	A = 0.2f;
	B = 0.0;
	C = 1.0;
	D = 1.0;

	ataAL = ataBL = ataCL = lastDiffSampleL = 0.0;
	iirSampleAL = iirSampleBL = last3SampleL = last2SampleL = last1SampleL = 0.0;
	ataAR = ataBR = ataCR = lastDiffSampleR = 0.0;
	iirSampleAR = iirSampleBR = last3SampleR = last2SampleR = last1SampleR = 0.0;

	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Density2::getParameterCount() const
{
  return kNumParameters;
}

void Density2::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        case kParamB: B = value; break;
        case kParamC: C = value; break;
        case kParamD: D = value; break;
		default: break; // unknown parameter, shouldn't happen!
    }
}

float Density2::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        case kParamB: return B; break;
        case kParamC: return C; break;
        case kParamD: return D; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Density2::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Density", kVstMaxParamStrLen); break;
		case kParamB: strncpy (text, "Highpass", kVstMaxParamStrLen); break;
		case kParamC: strncpy (text, "Output", kVstMaxParamStrLen); break;
		case kParamD: strncpy (text, "Dry/Wet", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Density2::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*5.0)-1.0, text, kVstMaxParamStrLen); break; //-1 to 4
        case kParamB: float2string (B, text, kVstMaxParamStrLen); break;
        case kParamC: float2string (C, text, kVstMaxParamStrLen); break;
        case kParamD: float2string (D, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Density2::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamB: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamC: strncpy (text, "", kVstMaxParamStrLen); break;
        case kParamD: strncpy (text, "", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
