/* ========================================
 *  Discontinuity - Discontinuity.h
 *  Copyright (c) airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "Discontinuity.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::Discontinuity {

Discontinuity::Discontinuity()
{
	A = 0.5;
	for(int count = 0; count < dscBuf+2; count++) {
		dBaL[count] = 0.0;
		dBbL[count] = 0.0;
		dBcL[count] = 0.0;
		dBaR[count] = 0.0;
		dBbR[count] = 0.0;
		dBcR[count] = 0.0;
	}
	dBaPosL = 0.0;
	dBbPosL = 0.0;
	dBcPosL = 0.0;
	dBaPosR = 0.0;
	dBbPosR = 0.0;
	dBcPosR = 0.0;
	dBaXL = 1;
	dBbXL = 1;
	dBcXL = 1;
	dBaXR = 1;
	dBbXR = 1;
	dBcXR = 1;
	
	fpdL = 1; while (fpdL < 16386) fpdL = rand()*UINT32_MAX;
	fpdR = 1; while (fpdR < 16386) fpdR = rand()*UINT32_MAX;
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int Discontinuity::getParameterCount() const
{
  return kNumParameters;
}

void Discontinuity::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float Discontinuity::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void Discontinuity::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Top dB", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void Discontinuity::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string ((A*70.0)+70.0, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void Discontinuity::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "dB", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
