/* ========================================
 *  Discontinuity - Discontinuity.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) Airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Discontinuity_Discontinuity_H
#define __Discontinuity_Discontinuity_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::Discontinuity {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //

const int dscBuf = 90;

class Discontinuity final : public SfxCoreExtensionV1
{
public:
    Discontinuity();
    ~Discontinuity();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	uint32_t fpdL;
	uint32_t fpdR;
	//default stuff
	
	double dBaL[dscBuf+5];
	double dBaPosL;
	int dBaXL;
	
	double dBbL[dscBuf+5];
	double dBbPosL;
	int dBbXL;
	
	double dBcL[dscBuf+5];
	double dBcPosL;
	int dBcXL;

	double dBaR[dscBuf+5];
	double dBaPosR;
	int dBaXR;
	
	double dBbR[dscBuf+5];
	double dBbPosR;
	int dBbXR;
	
	double dBcR[dscBuf+5];
	double dBcPosR;
	int dBcXR;

    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
