/* ========================================
 *  DustBunny - DustBunny.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#include "DustBunny.h"

#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include <cmath>
namespace airwinconsolidated::DustBunny {

DustBunny::DustBunny()
{
	A = 0.0;
	
	LataLast3Sample = LataLast2Sample = LataLast1Sample = 0.0;
	LataHalfwaySample = LataHalfDrySample = LataHalfDiffSample = 0.0;
	LataA = LataB = LataC = LataDrySample = LataDiffSample = LataPrevDiffSample = 0.0;
	LataUpsampleHighTweak = 0.0414213562373095048801688f; //more adds treble to upsampling
	LataDecay = 0.915965594177219015f; //Catalan's constant, more adds focus and clarity
	
	RataLast3Sample = RataLast2Sample = RataLast1Sample = 0.0;
	RataHalfwaySample = RataHalfDrySample = RataHalfDiffSample = 0.0;
	RataA = RataB = RataC = RataDrySample = RataDiffSample = RataPrevDiffSample = 0.0;
	RataUpsampleHighTweak = 0.0414213562373095048801688f; //more adds treble to upsampling
	RataDecay = 0.915965594177219015f; //CRatalan's constant, more adds focus and clarity
	LataFlip = false; //end reset of antialias parameters
	RataFlip = false; //end reset of antialias parameters
	//this is reset: values being initialized only once. Startup values, whatever they are.
}

int DustBunny::getParameterCount() const
{
  return kNumParameters;
}

void DustBunny::setParameter(int index, float value) {
    switch (index) {
        case kParamA: A = value; break;
        default: break; // unknown parameter, shouldn't happen!
    }
}

float DustBunny::getParameter(int index) {
    switch (index) {
        case kParamA: return A; break;
        default: break; // unknown parameter, shouldn't happen!
    } return 0.0; //we only need to update the relevant name, this is simple to manage
}

void DustBunny::getParameterName(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, "Bunny", kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
    } //this is our labels for displaying in the VST host
}

void DustBunny::getParameterDisplay(int index, char *text) {
    switch (index) {
        case kParamA: float2string (A, text, kVstMaxParamStrLen); break;
        default: break; // unknown parameter, shouldn't happen!
	} //this displays the values and handles 'popups' where it's discrete choices
}

void DustBunny::getParameterLabel(int index, char *text) {
    switch (index) {
        case kParamA: strncpy (text, " ", kVstMaxParamStrLen); break;
		default: break; // unknown parameter, shouldn't happen!
    }
}




} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS
