/* ========================================
 *  DustBunny - DustBunny.h
 *  Created 8/12/11 by SPIAdmin 
 *  Copyright (c) 2011 __MyCompanyName__, Airwindows uses the MIT license
 * ======================================== */

#ifndef __DustBunny_DustBunny_H
#define __DustBunny_DustBunny_H

#include "../../../configuration.h"
#ifdef SHR3D_SFX_CORE_AIRWINDOWS

#include "../common/airwin_consolidated_base.h"


namespace airwinconsolidated::DustBunny {
enum {
	kParamA = 0,
  kNumParameters = 1
}; //


class DustBunny final : public SfxCoreExtensionV1
{
public:
    DustBunny();
    ~DustBunny();
    void processBlock(float** inputs, float** outputs, int sampleFrames) override;
    int getParameterCount() const override;
    float getParameter(int index) override;
    void setParameter(int index, float value) override;
    void getParameterLabel(int index, char *text) override;
    void getParameterName(int index, char *text) override;
    void getParameterDisplay(int index, char *text) override;
private:
    
	float LataLast3Sample;
	float LataLast2Sample;
	float LataLast1Sample;
	float LataHalfwaySample;
	float LataHalfDrySample;
	float LataHalfDiffSample;
	float LataA;
	float LataB;
	float LataC;
	float LataDecay;
	float LataUpsampleHighTweak;
	float LataDrySample;
	float LataDiffSample;
	float LataPrevDiffSample;
	
	float RataLast3Sample;
	float RataLast2Sample;
	float RataLast1Sample;
	float RataHalfwaySample;
	float RataHalfDrySample;
	float RataHalfDiffSample;
	float RataA;
	float RataB;
	float RataC;
	float RataDecay;
	float RataUpsampleHighTweak;
	float RataDrySample;
	float RataDiffSample;
	float RataPrevDiffSample;
	
	bool LataFlip; //end defining of antialiasing variables
	bool RataFlip; //end defining of antialiasing variables
	
	uint32_t fpdL;
	uint32_t fpdR;
	
    float A;
};

} // end namespace

#endif // SHR3D_SFX_CORE_AIRWINDOWS

#endif
